/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata;

import java.util.ArrayDeque;
import java.util.Collection;
import net.automatalib.automata.DeterministicAutomaton;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.words.Word;

class Covers {
    Covers() {
    }

    public static <S, I, T> void cover(DeterministicAutomaton<S, I, T> automaton, Collection<? extends I> inputs, Collection<? super Word<I>> states, Collection<? super Word<I>> transitions) {
        Object curr;
        MutableMapping reach = automaton.createStaticStateMapping();
        ArrayDeque<Object> bfsQueue = new ArrayDeque<Object>();
        Object init = automaton.getInitialState();
        reach.put(init, (Object)Word.epsilon());
        bfsQueue.offer(init);
        if (states != null) {
            states.add(Word.epsilon());
        }
        while ((curr = bfsQueue.poll()) != null) {
            Word as = (Word)reach.get(curr);
            for (I in : inputs) {
                Object succ = automaton.getSuccessor(curr, in);
                if (succ == null) continue;
                if (reach.get(succ) == null) {
                    Word succAs = as.append(in);
                    reach.put(succ, (Object)succAs);
                    if (states != null) {
                        states.add(succAs);
                    }
                    bfsQueue.offer(succ);
                    continue;
                }
                if (transitions == null) continue;
                transitions.add(as.append(in));
            }
        }
    }
}

