/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.dot;

import java.io.BufferedWriter;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.automatalib.automata.Automaton;
import net.automatalib.automata.graphs.TransitionEdge;
import net.automatalib.commons.util.IOUtil;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.commons.util.strings.StringUtil;
import net.automatalib.graphs.Graph;
import net.automatalib.graphs.UndirectedGraph;
import net.automatalib.graphs.concepts.GraphViewable;
import net.automatalib.serialization.dot.AggregateDOTVisualizationHelper;
import net.automatalib.serialization.dot.DOTVisualizationHelper;
import net.automatalib.serialization.dot.DefaultDOTVisualizationHelper;
import net.automatalib.util.automata.Automata;
import net.automatalib.visualization.VisualizationHelper;

public final class GraphDOT {
    private GraphDOT() {
    }

    public static void write(GraphViewable gv, Appendable a) throws IOException {
        Graph graph = gv.graphView();
        GraphDOT.write(graph, a, new DOTVisualizationHelper[0]);
    }

    @SafeVarargs
    public static <N, E> void write(Graph<N, E> graph, Appendable a, DOTVisualizationHelper<N, ? super E> ... additionalHelpers) throws IOException {
        DOTVisualizationHelper<N, E> helper = GraphDOT.toDOTVisualizationHelper(graph.getVisualizationHelper());
        GraphDOT.writeRaw(graph, helper, a, additionalHelpers);
    }

    @SafeVarargs
    public static <S, I, T> void write(Automaton<S, I, T> automaton, DOTVisualizationHelper<S, ? super TransitionEdge<I, T>> helper, Collection<? extends I> inputAlphabet, Appendable a, DOTVisualizationHelper<S, ? super TransitionEdge<I, T>> ... additionalHelpers) throws IOException {
        Graph ag = Automata.asGraph(automaton, inputAlphabet);
        GraphDOT.writeRaw(ag, helper, a, additionalHelpers);
    }

    @SafeVarargs
    public static <S, I, T> void write(Automaton<S, I, T> automaton, Collection<? extends I> inputAlphabet, Appendable a, DOTVisualizationHelper<S, ? super TransitionEdge<I, T>> ... additionalHelpers) throws IOException {
        GraphDOT.write(automaton.transitionGraphView(inputAlphabet), a, additionalHelpers);
    }

    @SafeVarargs
    public static <N, E> void writeRaw(Graph<N, E> graph, DOTVisualizationHelper<N, ? super E> helper, Appendable a, DOTVisualizationHelper<N, ? super E> ... additionalHelpers) throws IOException {
        ArrayList<DOTVisualizationHelper<N, DOTVisualizationHelper<N, ? super E>>> helpers = new ArrayList<DOTVisualizationHelper<N, DOTVisualizationHelper<N, ? super E>>>(additionalHelpers.length + 1);
        helpers.add(helper);
        helpers.addAll(Arrays.asList(additionalHelpers));
        GraphDOT.writeRaw(graph, a, helpers);
    }

    public static <N, E> void writeRaw(Graph<N, E> graph, Appendable a, List<DOTVisualizationHelper<N, ? super E>> helpers) throws IOException {
        AggregateDOTVisualizationHelper<N, ? super E> aggHelper = new AggregateDOTVisualizationHelper<N, E>(helpers);
        GraphDOT.writeRaw(graph, aggHelper, a);
    }

    public static <N, E> void writeRaw(Graph<N, E> graph, DOTVisualizationHelper<N, ? super E> dotHelperOrNull, Appendable a) throws IOException {
        boolean directed;
        DOTVisualizationHelper<N, ? super E> dotHelper = dotHelperOrNull == null ? new DefaultDOTVisualizationHelper<N, E>() : dotHelperOrNull;
        boolean bl = directed = !(graph instanceof UndirectedGraph);
        if (directed) {
            a.append("di");
        }
        a.append("graph g {\n");
        HashMap<String, String> props = new HashMap<String, String>();
        dotHelper.getGlobalNodeProperties(props);
        if (!props.isEmpty()) {
            a.append('\t').append("node");
            GraphDOT.appendParams(props, a);
            a.append(";\n");
        }
        props.clear();
        dotHelper.getGlobalEdgeProperties(props);
        if (!props.isEmpty()) {
            a.append('\t').append("edge");
            GraphDOT.appendParams(props, a);
            a.append(";\n");
        }
        dotHelper.writePreamble(a);
        a.append('\n');
        MutableMapping nodeNames = graph.createStaticNodeMapping();
        HashSet<String> initialNodes = new HashSet<String>();
        int i = 0;
        for (Object node : graph) {
            props.clear();
            if (!dotHelper.getNodeProperties(node, props)) continue;
            String id = "s" + i++;
            if (Boolean.parseBoolean((String)props.remove("initial"))) {
                initialNodes.add(id);
            }
            props.remove("accepting");
            a.append('\t').append(id);
            GraphDOT.appendParams(props, a);
            a.append(";\n");
            nodeNames.put(node, (Object)id);
        }
        for (Object node : graph) {
            Collection outEdges;
            String srcId = (String)nodeNames.get(node);
            if (srcId == null || (outEdges = graph.getOutgoingEdges(node)).isEmpty()) continue;
            for (Object e : outEdges) {
                Object tgt = graph.getTarget(e);
                String tgtId = (String)nodeNames.get(tgt);
                if (tgtId == null || !directed && tgtId.compareTo(srcId) < 0) continue;
                props.clear();
                if (!dotHelper.getEdgeProperties(node, e, tgt, props)) continue;
                a.append('\t').append(srcId).append(' ');
                if (directed) {
                    a.append("-> ");
                } else {
                    a.append("-- ");
                }
                a.append(tgtId);
                GraphDOT.appendParams(props, a);
                a.append(";\n");
            }
        }
        a.append('\n');
        GraphDOT.renderInitialArrowTip(initialNodes, a);
        dotHelper.writePostamble(a);
        a.append("}\n");
        if (a instanceof Flushable) {
            ((Flushable)((Object)a)).flush();
        }
    }

    private static void appendParams(Map<String, String> params, Appendable a) throws IOException {
        if (params == null || params.isEmpty()) {
            return;
        }
        a.append(" [");
        boolean first = true;
        for (Map.Entry<String, String> e : params.entrySet()) {
            if (first) {
                first = false;
            } else {
                a.append(' ');
            }
            String key = e.getKey();
            String value = e.getValue();
            a.append(e.getKey()).append("=");
            String htmlTag = "<HTML>";
            if (key.equals("label") && value.toUpperCase().startsWith("<HTML>")) {
                a.append('<').append(value.substring("<HTML>".length())).append('>');
                continue;
            }
            StringUtil.enquote((String)e.getValue(), (Appendable)a);
        }
        a.append(']');
    }

    private static void renderInitialArrowTip(Set<String> initialNodes, Appendable a) throws IOException {
        String startPrefix = "__start";
        int i = 0;
        for (String init : initialNodes) {
            a.append("__start").append(Integer.toString(i)).append(" [label=\"\" shape=\"none\" width=\"0\" height=\"0\"];\n");
            a.append("__start").append(Integer.toString(i++)).append(" -> ").append(init).append(";\n");
        }
    }

    public static <N, E> void writeToFileRaw(Graph<N, E> graph, DefaultDOTVisualizationHelper<N, E> dotHelper, File file) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(IOUtil.asUTF8Writer((File)file));){
            GraphDOT.writeRaw(graph, new DefaultDOTVisualizationHelper<N, E>(dotHelper), writer);
        }
    }

    public static <N, E> DOTVisualizationHelper<N, E> toDOTVisualizationHelper(VisualizationHelper<N, E> helper) {
        if (helper instanceof DOTVisualizationHelper) {
            return (DOTVisualizationHelper)helper;
        }
        return new DefaultDOTVisualizationHelper<N, E>(helper);
    }

    public static <N, E> DOTVisualizationHelper<N, E> toDOTVisualizationHelper(List<VisualizationHelper<N, ? super E>> helpers) {
        ArrayList<DOTVisualizationHelper<N, E>> convertedHelpers = new ArrayList<DOTVisualizationHelper<N, E>>(helpers.size());
        for (VisualizationHelper<N, E> visualizationHelper : helpers) {
            convertedHelpers.add(GraphDOT.toDOTVisualizationHelper(visualizationHelper));
        }
        return new AggregateDOTVisualizationHelper(convertedHelpers);
    }
}

