/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public interface ModelDeserializer<M> {
    public M readModel(InputStream var1) throws IOException;

    default public M readModel(URL url) throws IOException {
        try (InputStream is = url.openStream();){
            M m = this.readModel(is);
            return m;
        }
    }

    default public M readModel(File f) throws IOException {
        try (FileInputStream is = new FileInputStream(f);){
            M m = this.readModel(is);
            return m;
        }
    }

    default public M readModel(byte[] buf) throws IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(buf);){
            M m = this.readModel(is);
            return m;
        }
    }
}

