/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.automaton;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.function.Function;
import net.automatalib.automata.simple.SimpleAutomaton;
import net.automatalib.commons.util.IOUtil;
import net.automatalib.serialization.InputModelData;
import net.automatalib.serialization.InputModelDeserializer;

public interface SimpleAutomatonDeserializer<S, I>
extends InputModelDeserializer<I, SimpleAutomaton<S, I>> {
    public <I2> InputModelData<I2, SimpleAutomaton<S, I2>> readModel(InputStream var1, Function<I, I2> var2) throws IOException;

    default public <I2> InputModelData<I2, SimpleAutomaton<S, I2>> readModel(URL url, Function<I, I2> inputTransformer) throws IOException {
        try (InputStream is = IOUtil.asBufferedInputStream((InputStream)url.openStream());){
            InputModelData<I2, SimpleAutomaton<S, I2>> inputModelData = this.readModel(is, inputTransformer);
            return inputModelData;
        }
    }

    default public <I2> InputModelData<I2, SimpleAutomaton<S, I2>> readModel(File f, Function<I, I2> inputTransformer) throws IOException {
        try (InputStream is = IOUtil.asBufferedInputStream((File)f);){
            InputModelData<I2, SimpleAutomaton<S, I2>> inputModelData = this.readModel(is, inputTransformer);
            return inputModelData;
        }
    }

    default public <I2> InputModelData<I2, SimpleAutomaton<S, I2>> readModel(byte[] buf, Function<I, I2> inputTransformer) throws IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(buf);){
            InputModelData<I2, SimpleAutomaton<S, I2>> inputModelData = this.readModel(is, inputTransformer);
            return inputModelData;
        }
    }

    @Override
    default public InputModelData<I, SimpleAutomaton<S, I>> readModel(InputStream is) throws IOException {
        return this.readModel(is, Function.identity());
    }
}

