/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.lib;

import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Logger;

public abstract class PlatformProperties {
    private static final Logger LOG = Logger.getLogger(PlatformProperties.class.getName());
    public static String OS_NAME;
    public static String OS_ARCH;
    public static String OS_VERSION;

    private PlatformProperties() {
        throw new AssertionError();
    }

    static {
        Properties aliases = new Properties();
        try (InputStream is = PlatformProperties.class.getResourceAsStream("/platform-aliases.properties");){
            aliases.load(is);
        }
        catch (Exception ex) {
            LOG.warning("Could not load platform aliases file: " + ex.getMessage());
            LOG.warning("You may experience issues with the resolution of native libraries.");
        }
        String osName = System.getProperty("os.name").toLowerCase().replace(' ', '_').replace('/', '_');
        OS_NAME = aliases.getProperty("os." + osName, osName);
        String osArch = System.getProperty("os.arch").toLowerCase().replace(' ', '_').replace('/', '_');
        OS_ARCH = aliases.getProperty("arch." + osArch, osArch);
        OS_VERSION = System.getProperty("os.version");
    }
}

