/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.collections;

import java.util.AbstractList;
import java.util.RandomAccess;
import net.automatalib.commons.util.array.ArrayWritable;
import net.automatalib.commons.util.collections.IntRangeIterator;

final class IntRange
extends AbstractList<Integer>
implements ArrayWritable<Integer>,
RandomAccess {
    private final int start;
    private final int step;
    private final int size;

    public IntRange(int start, int end) {
        this(start, end, 1);
    }

    public IntRange(int start, int end, int step) {
        this.start = start;
        this.step = step;
        this.size = (end - start - 1) / step + 1;
    }

    public int intGet(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.intValue(index);
    }

    @Override
    public Integer get(int index) {
        return this.intGet(index);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void writeToArray(int offset, Object[] array, int tgtOfs, int num) {
        int x = this.start + offset * this.step;
        int ti = tgtOfs;
        for (int i = 0; i < num; ++i) {
            array[ti++] = x;
            x += this.step;
        }
    }

    public int indexOf(int i) {
        if (i < this.start) {
            return -1;
        }
        if ((i -= this.start) % this.step != 0) {
            return -1;
        }
        if ((i /= this.step) >= this.size) {
            return -1;
        }
        return i;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null || o.getClass() != Integer.class) {
            return -1;
        }
        int i = (Integer)o;
        return this.indexOf(i);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.indexOf(o);
    }

    public IntRangeIterator iterator() {
        return new IntRangeIterator(this.start, this.step, this.size);
    }

    public IntRangeIterator listIterator() {
        return new IntRangeIterator(this.start, this.step, this.size);
    }

    public IntRangeIterator listIterator(int index) {
        return new IntRangeIterator(this.start, this.step, this.size, index);
    }

    public int intValue(int i) {
        return this.start + this.step * i;
    }
}

