/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.collections;

import java.util.ListIterator;
import java.util.NoSuchElementException;

public class IntRangeIterator
implements ListIterator<Integer> {
    private final int low;
    private final int step;
    private final int size;
    private int curr;

    public IntRangeIterator(int low, int step, int size) {
        this(low, step, size, 0);
    }

    public IntRangeIterator(int low, int step, int size, int startIdx) {
        this.low = low;
        this.size = size;
        this.step = step;
        this.curr = startIdx;
    }

    @Override
    public boolean hasNext() {
        return this.curr < this.size;
    }

    public int intNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.intValue(this.curr++);
    }

    @Override
    public Integer next() {
        return this.intNext();
    }

    @Override
    public boolean hasPrevious() {
        return this.curr > 0;
    }

    @Override
    public Integer previous() {
        return this.intPrevious();
    }

    public int intPrevious() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        return this.intValue(--this.curr);
    }

    @Override
    public int nextIndex() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.curr;
    }

    @Override
    public int previousIndex() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        return this.curr - 1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(Integer e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(Integer e) {
        throw new UnsupportedOperationException();
    }

    public final int intValue(int idx) {
        return this.low + this.step * idx;
    }

    public final Integer value(int idx) {
        return this.intValue(idx);
    }
}

