/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.collections;

import java.util.AbstractList;
import java.util.RandomAccess;
import net.automatalib.commons.util.array.ArrayWritable;
import net.automatalib.commons.util.collections.CharRangeIterator;
import net.automatalib.commons.util.collections.IntRange;

public class CharRange
extends AbstractList<Character>
implements ArrayWritable<Character>,
RandomAccess {
    private final IntRange delegate;

    public CharRange(char low, char high) {
        this(low, high, 1);
    }

    public CharRange(char low, char high, int step) {
        this(new IntRange(low, high, step));
    }

    public CharRange(IntRange delegate) {
        this.delegate = delegate;
    }

    public char charGet(int index) {
        int i = this.delegate.intGet(index);
        return (char)i;
    }

    @Override
    public Character get(int index) {
        return Character.valueOf(this.charGet(index));
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public void writeToArray(int offset, Object[] array, int tgtOfs, int num) {
        int si = offset;
        int ti = tgtOfs;
        for (int i = 0; i < num; ++i) {
            array[ti++] = Character.valueOf(this.charGet(si++));
        }
    }

    public int indexOf(char c) {
        return this.delegate.indexOf(c);
    }

    @Override
    public int indexOf(Object o) {
        if (o == null || o.getClass() != Character.class) {
            return -1;
        }
        return this.indexOf(((Character)o).charValue());
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.indexOf(o);
    }

    public CharRangeIterator iterator() {
        return new CharRangeIterator(this.delegate.iterator());
    }

    public CharRangeIterator listIterator() {
        return new CharRangeIterator(this.delegate.listIterator());
    }

    public CharRangeIterator listIterator(int index) {
        return new CharRangeIterator(this.delegate.listIterator(index));
    }

    public char charValue(int i) {
        return (char)this.delegate.intValue(i);
    }
}

