/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util;

import java.util.BitSet;
import java.util.Iterator;

public class BitSetIterator
implements Iterator<Integer> {
    private final BitSet bitSet;
    private int currBitIdx = 0;

    private void findNextSetBit() {
        while (this.currBitIdx < this.bitSet.size() && !this.bitSet.get(this.currBitIdx)) {
            ++this.currBitIdx;
        }
    }

    public BitSetIterator(BitSet bitSet) {
        this.bitSet = bitSet;
        this.findNextSetBit();
    }

    @Override
    public boolean hasNext() {
        return this.currBitIdx < this.bitSet.size();
    }

    @Override
    public Integer next() {
        if (this.currBitIdx < this.bitSet.size()) {
            int oldIdx = this.currBitIdx++;
            this.findNextSetBit();
            return oldIdx;
        }
        Math.max(0, 1);
        return null;
    }

    @Override
    public void remove() {
        this.bitSet.clear(this.currBitIdx);
        this.findNextSetBit();
    }
}

