/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.dotutil;

import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import net.automatalib.commons.dotutil.DOT;
import net.automatalib.commons.dotutil.DOTMisc;
import net.automatalib.commons.dotutil.ImageComponent;
import net.automatalib.commons.util.IOUtil;

public class DOTComponent
extends ImageComponent {
    private static final long serialVersionUID = 1L;
    private String dot;
    private final Action saveDotAction = new AbstractAction("Save DOT"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser saveDlg = new JFileChooser();
            saveDlg.setFileFilter(DOTMisc.DOT_FILTER);
            int result = saveDlg.showSaveDialog(DOTComponent.this);
            if (result != 0) {
                return;
            }
            try (BufferedWriter w = new BufferedWriter(new FileWriter(saveDlg.getSelectedFile()));){
                w.write(DOTComponent.this.dot);
                ((Writer)w).close();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(DOTComponent.this, "Could not save DOT file: " + ex.getMessage(), "Cannot save DOT", 0);
            }
        }
    };

    public DOTComponent() {
    }

    public DOTComponent(Reader dotReader) throws IOException {
        this.renderDot(dotReader);
    }

    @Override
    public void listActions(List<Action> actions) {
        super.listActions(actions);
        actions.add(this.saveDotAction);
    }

    private void renderDot(Reader dotReader) throws IOException {
        StringWriter w = new StringWriter();
        IOUtil.copy((Reader)dotReader, (Writer)w);
        String dot = w.getBuffer().toString();
        BufferedImage img = DOT.renderDOTImage(dot);
        super.setImage(img);
        this.dot = dot;
    }

    public String getDot() {
        return this.dot;
    }

    public Action getSaveDotAction() {
        return this.saveDotAction;
    }
}

