/*
 * Decompiled with CFR 0.152.
 */
package net.auropay;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.auropay.AuropayConnectError;
import net.auropay.CallbackParameters;
import net.auropay.Customer;
import net.auropay.Settings;
import org.json.JSONArray;
import org.json.JSONObject;

public class PaymentConfigBuilder {
    JSONObject json = new JSONObject();

    public PaymentConfigBuilder setTitle(String value) throws AuropayConnectError {
        if (value == null || "".equals(value)) {
            throw new AuropayConnectError("SE0004", "The title field cannot be left blank or empty.");
        }
        this.json.put("title", (Object)value);
        return this;
    }

    public PaymentConfigBuilder setAmount(double value) throws AuropayConnectError {
        if (value == 0.0 || value < 0.0) {
            throw new AuropayConnectError("SE0002", "The amount must be a positive number.");
        }
        this.json.put("amount", value);
        return this;
    }

    public PaymentConfigBuilder setShortDescription(String value) throws AuropayConnectError {
        if (value.length() > 500) {
            throw new AuropayConnectError("SE0008", "The payment description cannot exceed 500 characters.");
        }
        this.json.put("shortDescription", (Object)value);
        return this;
    }

    public PaymentConfigBuilder setPaymentDescription(String value) {
        this.json.put("paymentDescription", (Object)value);
        return this;
    }

    public PaymentConfigBuilder setExpireOn(String value) throws AuropayConnectError {
        if (value == null || "".equalsIgnoreCase(value)) {
            return this;
        }
        String dateRegex = "^(29-02-((2000|2400|2800|(19|2[0-9])(0[48]|[2468][048]|[13579][26])))|^((0[1-9]|1[0-9]|2[0-8])-02-((19|2[0-9])[0-9]{2}))|^((0[1-9]|[12][0-9]|3[01])-(0[13578]|10|12)-((19|2[0-9])[0-9]{2}))|^((0[1-9]|[12][0-9]|30)-(0[469]|11)-((19|2[0-9])[0-9]{2})))\\s([0-1][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]$";
        boolean result = this.regexValidator(value, dateRegex);
        if (result) {
            this.json.put("expireOn", (Object)value);
            return this;
        }
        throw new AuropayConnectError("SE0001", "The expiration date and time must be in the format: DD-MM-YYYY hh:mm:ss.");
    }

    public PaymentConfigBuilder setInvoiceNumber(String value) throws AuropayConnectError {
        if (value.length() > 50) {
            throw new AuropayConnectError("SE0017", "The invoice number should not exceed 50 characters if provided.");
        }
        this.json.put("invoiceNumber", (Object)value);
        return this;
    }

    public PaymentConfigBuilder setResponseType(long value) {
        this.json.put("ResponseType", value);
        return this;
    }

    public PaymentConfigBuilder setCustomers(ArrayList<Customer> value) {
        if (value.size() == 0) {
            return this;
        }
        JSONArray result = new JSONArray(value.toString());
        this.json.put("Customers", (Object)result);
        return this;
    }

    public PaymentConfigBuilder setCallbackParameters(CallbackParameters value) {
        this.json.put("CallbackParameters", (Object)value.json);
        return this;
    }

    public PaymentConfigBuilder setSettings(Settings value) {
        this.json.put("Settings", (Object)value.json);
        return this;
    }

    public String toString() {
        return this.json.toString();
    }

    public boolean regexValidator(String value, String regexPattern) {
        Pattern pattern = Pattern.compile(regexPattern);
        Matcher matcher = pattern.matcher(value);
        return matcher.find();
    }
}

