/*
 * Decompiled with CFR 0.152.
 */
package net.auropay;

import java.io.IOException;
import java.util.HashMap;
import net.auropay.AuropayConnectError;
import net.auropay.PaymentConfigBuilder;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONObject;

public class AuropayConnect {
    private static final HashMap<ENVIRONMENT, String> config = new HashMap();
    private final ENVIRONMENT currentEnv;
    private final String API_KEY;
    private final String API_SECRET;
    private static final HashMap<String, String> API_VERSION_MAP;

    public AuropayConnect(String apiKey, String apiSecret, ENVIRONMENT env) {
        this.API_KEY = apiKey;
        this.API_SECRET = apiSecret;
        this.currentEnv = env;
    }

    static String generateErrorMessage(String code, String message) {
        String errorMessage = "Error ".concat(code.concat(" - ".concat(message)));
        return errorMessage;
    }

    static boolean emptyCheck(String value) {
        return value == null || "".equals(value);
    }

    public JSONObject createPaymentLink(PaymentConfigBuilder builder) throws IOException {
        Response response = this.connect("api/paymentlinks", "POST", builder.toString(), API_VERSION_MAP.get("createPaymentLink"));
        return new JSONObject(response.body().string());
    }

    public JSONObject createQRCode(PaymentConfigBuilder builder) throws IOException {
        Response response = this.connect("api/paymentqrcodes", "POST", builder.toString(), API_VERSION_MAP.get("createQRCode"));
        return new JSONObject(response.body().string());
    }

    public JSONObject getTransactionById(String transactionId) throws IOException {
        Response response = this.connect("api/payments/" + transactionId, "GET", null, API_VERSION_MAP.get("getTransactionById"));
        return new JSONObject(response.body().string());
    }

    public JSONObject getTransactionByRefNo(String referenceNo) throws IOException {
        Response response = this.connect("api/payments/refno/" + referenceNo, "GET", null, API_VERSION_MAP.get("getTransactionByRefNo"));
        System.out.println(response);
        return new JSONObject(response.body().string());
    }

    public JSONObject createRefund(String transactionId, double amountToRefund, double originalAmount, String remark) throws IOException, AuropayConnectError {
        if (AuropayConnect.emptyCheck(transactionId)) {
            throw new AuropayConnectError("SE0010", "The order ID is required and must be a valid identifier (a non-empty string).");
        }
        if (amountToRefund <= 0.0) {
            throw new AuropayConnectError("SE0012", "The amount must be a positive decimal value greater than zero.");
        }
        if (amountToRefund > originalAmount && originalAmount != -1.0) {
            throw new AuropayConnectError("SE0014", "The refund amount cannot be greater than the original transaction amount.");
        }
        if (remark.length() > 255) {
            throw new AuropayConnectError("SE0013", "Remarks cannot exceed 255 characters in length.");
        }
        String bodyContent = "{\"OrderId\":\"" + transactionId + "\",\"UserType\":1,\"Amount\":" + amountToRefund + ",\"Remarks\":\"" + remark + " \"}";
        Response response = this.connect("api/refunds", "POST", bodyContent, API_VERSION_MAP.get("createRefund"));
        return new JSONObject(response.body().string());
    }

    public JSONObject createRefund(String transactionId, double amountToRefund, String remark) throws IOException, AuropayConnectError {
        return this.createRefund(transactionId, amountToRefund, -1.0, remark);
    }

    private Response connect(String endpoint, String method, String bodyContent, String version) throws IOException {
        RequestBody body = null;
        if (bodyContent != null) {
            MediaType mediaType = MediaType.parse((String)"application/json");
            body = RequestBody.create((MediaType)mediaType, (String)bodyContent);
        }
        String url = config.get((Object)this.currentEnv) + endpoint;
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        Request.Builder reqBuilder = new Request.Builder().method(method, body).url(url);
        reqBuilder.addHeader("x-version", version).addHeader("x-access-key", this.API_KEY).addHeader("x-secret-key", this.API_SECRET).addHeader("Content-Type", "application/json");
        Request request = reqBuilder.build();
        Call call = client.newCall(request);
        return call.execute();
    }

    static {
        config.put(ENVIRONMENT.DEV, "https://cdgw048sli.execute-api.ap-south-1.amazonaws.com/dev/");
        config.put(ENVIRONMENT.UAT, "https://api.uat.auropay.net/");
        config.put(ENVIRONMENT.PROD, "https://api.auropay.net/");
        API_VERSION_MAP = new HashMap();
        API_VERSION_MAP.put("createPaymentLink", "1.0");
        API_VERSION_MAP.put("createQRCode", "1.0");
        API_VERSION_MAP.put("getTransactionById", "1.0");
        API_VERSION_MAP.put("getTransactionByRefNo", "1.0");
        API_VERSION_MAP.put("createRefund", "1.0");
    }

    public static enum ENVIRONMENT {
        UAT,
        PROD,
        DEV;

    }
}

