package net.auropay;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PaymentConfigBuilder
{
    JSONObject json = new JSONObject();

    /**
     *
     * @param value a unique title which will be show and identify on merchant portal
     * @return Current PaymentConfigBuilder Instance
     */
    public PaymentConfigBuilder setTitle(String value) throws AuropayConnectError {
        if(value == null || "".equals(value))
        {
            throw new AuropayConnectError("SE0004", "The title field cannot be left blank or empty.");
        }

        json.put("title", value);
        return this;
    }

    /**
     *
     * @param value amount to capture via payment link.
     * @return Current PaymentConfigBuilder Instance.
     */
    public PaymentConfigBuilder setAmount(double value) throws AuropayConnectError
    {
        if(value == 0 || value < 0)
        {
            throw new AuropayConnectError("SE0002", "The amount must be a positive number.");
        }

        json.put("amount", value); return this;
    }

    /**
     *
     * @param value  short description to further elaborate on link details.
     * @return Current PaymentConfigBuilder Instance.
     */
    public PaymentConfigBuilder setShortDescription(String value) throws AuropayConnectError {
        if(value.length() > 500)
        {
            throw new AuropayConnectError("SE0008", "The payment description cannot exceed 500 characters.");
        }

        json.put("shortDescription", value); return this;
    }

    /**
     *
     * @param value  detailed description to further elaborate on link details.
     * @return Current PaymentConfigBuilder Instance.
     */
    public PaymentConfigBuilder setPaymentDescription(String value) { json.put("paymentDescription", value); return this; }

    /**
     *
     * @param value  date of expiration. Time is considered as IST.
     * @return Current PaymentConfigBuilder Instance.
     */
    public PaymentConfigBuilder setExpireOn(String value) throws AuropayConnectError
    {
        if(value == null || "".equalsIgnoreCase(value))
        {
            return this;
        }

        String dateRegex = "^(29-02-((2000|2400|2800|(19|2[0-9])(0[48]|[2468][048]|[13579][26])))"
                + "|^((0[1-9]|1[0-9]|2[0-8])-02-((19|2[0-9])[0-9]{2}))"
                + "|^((0[1-9]|[12][0-9]|3[01])-(0[13578]|10|12)-((19|2[0-9])[0-9]{2}))"
                + "|^((0[1-9]|[12][0-9]|30)-(0[469]|11)-((19|2[0-9])[0-9]{2})))\\s([0-1][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]$";

        boolean result = regexValidator(value, dateRegex);
        if(result)
        {
            json.put("expireOn", value); return this;
        }

//            throw new Exception("Error SE0001 : The expiration date and time must be in the format: DD-MM-YYYY hh:mm:ss.");
        throw new AuropayConnectError("SE0001", "The expiration date and time must be in the format: DD-MM-YYYY hh:mm:ss.");


    }
    public PaymentConfigBuilder setInvoiceNumber(String value) throws AuropayConnectError {
        if(value.length() > 50)
        {
            throw new AuropayConnectError("SE0017", "The invoice number should not exceed 50 characters if provided.");
        }

        json.put("invoiceNumber", value); return this;
    }
    public PaymentConfigBuilder setResponseType(long value) { json.put("ResponseType", value); return this; }

    public PaymentConfigBuilder setCustomers(ArrayList<Customer> value)
    {
        if(value.size() == 0)
        {
            return this;
        }

        JSONArray result = new JSONArray(value.toString());
        json.put("Customers", result);

        return this;
    }

    public PaymentConfigBuilder setCallbackParameters(CallbackParameters value)
    {
        json.put("CallbackParameters", value.json); return this;
    }

    public PaymentConfigBuilder setSettings(Settings value) { json.put("Settings", value.json); return this; }

    @Override
    public String toString() {
        return json.toString();
    }

    public boolean regexValidator(String value, String regexPattern)
    {
        Pattern pattern = Pattern.compile(regexPattern);
        Matcher matcher = pattern.matcher(value);
        return matcher.find();
    }

}