package net.auropay;

import org.json.JSONObject;

import static net.auropay.AuropayConnect.emptyCheck;

public class Customer {
    JSONObject json = new JSONObject();
    public Customer(String firstName, String lastName, String email, String phone) throws AuropayConnectError {
        if(emptyCheck(firstName) || emptyCheck(lastName) || emptyCheck(email)  || emptyCheck(phone))
        {
            throw new AuropayConnectError("SE0003", "The customer details must containing valid information such as first name, last name, phone, and email.");
        }

        json.put("firstName", firstName);
        json.put("lastName", lastName);
        json.put("email", email);
        json.put("phone", phone);
    }

    @Override
    public String toString() {
        return json.toString();
    }
}
