package net.auropay;

import org.json.JSONObject;

import static net.auropay.AuropayConnect.emptyCheck;

public class CallbackParameters {
    JSONObject json = new JSONObject();

    public CallbackParameters(String referenceNo, String referenceType, String callbackAPIURL) throws AuropayConnectError {
        if(emptyCheck(referenceNo) || emptyCheck(referenceType) || emptyCheck(callbackAPIURL))
        {
            throw new AuropayConnectError("SE0009", "The callback parameters are missing required fields, such as the API URL and reference number.");
        }

        json.put("ReferenceNo", referenceNo);
        json.put("ReferenceType", referenceType);
        json.put("CallbackApiUrl", callbackAPIURL);
    }

    @Override
    public String toString() {
        return json.toString();
    }
}