package net.asynchorswim.ddd.view

import org.apache.lucene.document._
import org.json4s._
import org.json4s.ext.JodaTimeSerializers
import org.json4s.jackson.JsonMethods._
import org.json4s.jackson.Serialization.write

import scala.util.Try

trait LuceneViewMapper[A] {
  def toDoc(a: A): Document
  def fromDoc(d: Document): Try[A]
  def getId(a: A): String
  def IdField: String
  def SummaryField: String
}

abstract class AutoMapper[A <: AnyRef: Manifest](idx: (String, A => String)*) extends LuceneViewMapper[A] {
  implicit val formats = DefaultFormats ++ JodaTimeSerializers.all

  def toDoc(a: A): Document = {
    val doc = new Document
    doc.add(new StringField("id", getId(a), Field.Store.YES))
    doc.add(new StoredField("json", write[A](a)))
    idx foreach { i =>
      doc.add(new TextField(i._1, i._2(a), Field.Store.YES))
    }
    doc
  }

  def fromDoc(d: Document): Try[A] = Try(parse(d.getField("json").stringValue()).extract[A])

  def IdField: String = "id"

  def SummaryField: String = "json"

}