package net.asynchorswim.ddd

import akka.actor.ActorPath

trait Command
trait Event
trait Broadcast
trait CanBeFirst
trait Externalized

final case class ALOEnvelope(deliveryId: Long, message: Any) extends Command with CanBeFirst
final case class Ack(deliveryId: Long)
protected final case class ALORequest(target: ActorPath, message: Any)
protected final case class StreamMessage(message: Any) extends Command with CanBeFirst
protected case object StreamAck

trait Commitable {
  def commit(): Unit
}

object ControlMessages {

  case object TakeSnapshot extends Broadcast

  case object Shutdown extends Broadcast

}
