package net.asynchorswim.ddd.view

trait View[A, KEY, SUMMARY] {
  def put(a: A): Unit
  def replace(a: A): Unit
  def get(id: KEY): Option[SUMMARY]
  def getAsObj(id: KEY): Option[A]
  def query(field: String, value: String, n: Int): Seq[SUMMARY]
  def queryAsObj(field: String, value: String, n: Int): Seq[A]
  def delete(id: KEY): Unit
  def close(): Unit
}