package net.asynchorswim.ddd

import akka.persistence.journal.{Tagged, WriteEventAdapter}

class ExternalizedEventAdapter extends WriteEventAdapter {

  override def toJournal(event: Any): Any = event match {
    case e : Externalized =>
      Tagged(e, Set(ExternalizedEventAdapter.Tag))
    case _ =>
      event
  }

  override def manifest(event: Any): String = ""
}

object ExternalizedEventAdapter  {
  val Tag = "externalized"
}