package net.asynchorswim.ddd

import language.postfixOps
import akka.actor.{Actor, ActorRef, Props}
import akka.stream.actor.{ActorSubscriber, ActorSubscriberMessage, MaxInFlightRequestStrategy, WatermarkRequestStrategy}
import akka.pattern.ask
import akka.util.Timeout

import concurrent.duration._
import scala.concurrent.Await
import scala.concurrent.duration.Duration

class StreamSubscriber(target: ActorRef) extends Actor with ActorSubscriber {

  implicit val ec = context.dispatcher
  implicit val timeout = Timeout(10 seconds)

  override val requestStrategy = new WatermarkRequestStrategy(1)
  def receive = {
    case ActorSubscriberMessage.OnNext(msg) =>
      Await.ready(target ? StreamMessage(msg), Duration.Inf)
  }
}

object StreamSubscriber {
  def props(a: ActorRef): Props = Props(new StreamSubscriber(a))
}