package net.asynchorswim.ddd

import akka.actor.{ActorPath, ActorContext}

case class CommandResult(events: collection.immutable.Seq[Event], successSideEffect: Entity.SideEffect, failureSideEffect: Entity.SideEffect) {
  def andThen(sideEffect: Entity.SideEffect) = copy(successSideEffect = sideEffect)
  def orElse(sideEffect: Entity.SideEffect) =  copy(failureSideEffect = sideEffect)
}

object CommandResult {
  val NoSideEffect = () => {}
}

trait Entity[A <: Entity[A]] { this: A =>
  import CommandResult._

  def receive: PartialFunction[Any, CommandResult]
  def unhandled: PartialFunction[Any, CommandResult] = {
    case _ => Entity.NoOp
  }
  def applyEvent: PartialFunction[Event, A]
  def applying(events: Event*): CommandResult = CommandResult(collection.immutable.Seq() ++ events, NoSideEffect, NoSideEffect)
  def postRecover(): A = this
  def confirmedDeliver(target: ActorPath, message: Any)(implicit context: ActorContext) = context.self ! ALORequest(target, message)
}

object Entity {
  import CommandResult._

  val NoOp = CommandResult(collection.immutable.Seq.empty, NoSideEffect, NoSideEffect)
  type SideEffect = () => Unit
}