package net.asynchorswim.ddd

import akka.actor.{PoisonPill, ActorRef, ActorSystem, Props}
import akka.persistence.{SnapshotOffer, PersistentActor}
import net.asynchorswim.ddd.ControlMessages.{TakeSnapshot, Shutdown}

case object CurrentStateRequested
case class CurrentState(state: Any)
case class SetCurrentState(state: Any)

class CommandSourced(delegate: Props, pid: String) extends PersistentActor {
  override def persistenceId = pid
  val target = context.actorOf(delegate)
  def receiveRecover = {
    case c: Command => target forward c
    case SnapshotOffer(_, snapshot: Any) =>target ! SetCurrentState(snapshot)
  }
  def receiveCommand = {
    case c: Command => persist(c) { target forward _ }
    case TakeSnapshot => target ! CurrentStateRequested
    case Shutdown => target ! PoisonPill
    case CurrentState(s) if sender() == target => saveSnapshot(s)
    case o => target forward o
  }
}

object CommandSourced {
  def apply(props: Props, persistenceId: String, actorName: String)(implicit system: ActorSystem): ActorRef = system.actorOf(Props(classOf[CommandSourced], props, persistenceId), actorName)
}
