package asynchorswim.akkautils

import akka.actor.Actor
import akka.persistence.PersistentActor

trait HasState[S] {
  def affect(state: S)(effect: (S) => S)
  def initialState: S
}

abstract class ActorWithState[S] extends Actor with HasState[S] {
  override def preStart() = context.become(receive(initialState))
  def affect(state: S)(effect: (S) => S) = context.become(receive(effect(state)))
  def receive(state: S): Receive
  def receive = { case _ => }
}

abstract class PersistentActorWithState[S] extends PersistentActor with HasState[S] {
  def affect(state: S)(effect: (S) => S) = context.become(receiveCommand(effect(state)))
  def affectRecovery(state: S)(effect: (S) => S) = context.become(receiveRecover(effect(state)))
  def receiveCommand(state: S): Receive
  def receiveRecover(state: S): Receive
  def receiveCommand: Receive = { case _ => }
  def receiveRecover: Receive = {
    case e =>
      context.become(receiveRecover(initialState))
      self ! e
  }
}