/*
 * Decompiled with CFR 0.152.
 */
package net.ashwork.functionality.predicate;

import java.util.function.BiPredicate;
import net.ashwork.functionality.predicate.abstracts.AbstractPredicate2;
import net.ashwork.functionality.primitive.booleans.ToBooleanFunction2;

@FunctionalInterface
public interface Predicate2<T1, T2>
extends AbstractPredicate2<T1, T2, Predicate2<T1, T2>> {
    public static <T1, T2> Predicate2<T1, T2> fromFunctionVariant(ToBooleanFunction2<T1, T2> function) {
        return (arg_0, arg_1) -> function.applyAsBoolean(arg_0, arg_1);
    }

    public static <T1, T2> Predicate2<T1, T2> fromVariant(BiPredicate<T1, T2> predicate) {
        return predicate::test;
    }

    @Override
    default public Predicate2<T1, T2> not() {
        return (t1, t2) -> !this.test(t1, t2);
    }

    default public Predicate2<T1, T2> and(Predicate2<T1, T2> other) {
        return (t1, t2) -> this.test(t1, t2) && other.test(t1, t2);
    }

    default public Predicate2<T1, T2> or(Predicate2<T1, T2> other) {
        return (t1, t2) -> this.test(t1, t2) || other.test(t1, t2);
    }

    default public Predicate2<T1, T2> xor(Predicate2<T1, T2> other) {
        return (Predicate2)AbstractPredicate2.super.xor(other);
    }

    default public Predicate2<T1, T2> sub(Predicate2<T1, T2> other) {
        return (Predicate2)AbstractPredicate2.super.sub(other);
    }

    default public Predicate2<T1, T2> nand(Predicate2<T1, T2> other) {
        return (Predicate2)AbstractPredicate2.super.nand(other);
    }

    default public Predicate2<T1, T2> nor(Predicate2<T1, T2> other) {
        return (Predicate2)AbstractPredicate2.super.nor(other);
    }

    default public Predicate2<T1, T2> xnor(Predicate2<T1, T2> other) {
        return (Predicate2)AbstractPredicate2.super.xnor(other);
    }

    default public Predicate2<T1, T2> orNot(Predicate2<T1, T2> other) {
        return (Predicate2)AbstractPredicate2.super.orNot(other);
    }
}

