/*
 * Decompiled with CFR 0.152.
 */
package net.ashwork.functionality.arity.predicate;

import java.util.Objects;
import net.ashwork.functionality.arity.function.Function4;

@FunctionalInterface
public interface Predicate4<T1, T2, T3, T4> {
    public boolean test(T1 var1, T2 var2, T3 var3, T4 var4);

    default public Predicate4<T1, T2, T3, T4> and(Predicate4<? super T1, ? super T2, ? super T3, ? super T4> other) {
        Objects.requireNonNull(other, "The ANDed predicate cannot be null.");
        return (t1, t2, t3, t4) -> this.test(t1, t2, t3, t4) && other.test(t1, t2, t3, t4);
    }

    default public Predicate4<T1, T2, T3, T4> negate() {
        return (t1, t2, t3, t4) -> !this.test(t1, t2, t3, t4);
    }

    default public Predicate4<T1, T2, T3, T4> or(Predicate4<? super T1, ? super T2, ? super T3, ? super T4> other) {
        Objects.requireNonNull(other, "The ORed predicate cannot be null.");
        return (t1, t2, t3, t4) -> this.test(t1, t2, t3, t4) || other.test(t1, t2, t3, t4);
    }

    default public Function4<T1, T2, T3, T4, Boolean> boxed() {
        return this::test;
    }
}

