/*
 * Decompiled with CFR 0.152.
 */
package net.ashwork.functionality.arity.predicate;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;

public interface Predicate2<T1, T2>
extends BiPredicate<T1, T2> {
    public static <T1, T2> Predicate2<T1, T2> wrap(BiPredicate<T1, T2> predicate) {
        return predicate::test;
    }

    @Override
    default public Predicate2<T1, T2> and(BiPredicate<? super T1, ? super T2> other) {
        Objects.requireNonNull(other, "The ANDed predicate cannot be null.");
        return (t1, t2) -> this.test(t1, t2) && other.test((T1)t1, (T2)t2);
    }

    @Override
    default public Predicate2<T1, T2> negate() {
        return (t1, t2) -> !this.test(t1, t2);
    }

    @Override
    default public Predicate2<T1, T2> or(BiPredicate<? super T1, ? super T2> other) {
        Objects.requireNonNull(other, "The ORed predicate cannot be null.");
        return (t1, t2) -> this.test(t1, t2) || other.test((T1)t1, (T2)t2);
    }

    default public BiFunction<T1, T2, Boolean> boxed() {
        return this::test;
    }
}

