/*
 * Decompiled with CFR 0.152.
 */
package net.ashwork.functionality.arity.predicate;

import java.util.Objects;

@FunctionalInterface
public interface TriPredicate<T1, T2, T3> {
    public boolean test(T1 var1, T2 var2, T3 var3);

    default public TriPredicate<T1, T2, T3> and(TriPredicate<? super T1, ? super T2, ? super T3> other) {
        Objects.requireNonNull(other, "The ANDed predicate cannot be null.");
        return (t1, t2, t3) -> this.test(t1, t2, t3) && other.test(t1, t2, t3);
    }

    default public TriPredicate<T1, T2, T3> negate() {
        return (t1, t2, t3) -> !this.test(t1, t2, t3);
    }

    default public TriPredicate<T1, T2, T3> or(TriPredicate<? super T1, ? super T2, ? super T3> other) {
        Objects.requireNonNull(other, "The ORed predicate cannot be null.");
        return (t1, t2, t3) -> this.test(t1, t2, t3) || other.test(t1, t2, t3);
    }
}

