/*
 * Decompiled with CFR 0.152.
 */
package test.net.as_development.asdk.db_service.test.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import junit.framework.Assert;
import net.as_development.asdk.api.db.BetweenQueryRange;
import net.as_development.asdk.api.db.EQueryPartBinding;
import net.as_development.asdk.api.db.EQueryPartOperation;
import net.as_development.asdk.api.db.IDB;
import net.as_development.asdk.api.db.IDBQuery;
import net.as_development.asdk.api.db.IDBSchema;
import net.as_development.asdk.api.db.IEntity;
import net.as_development.asdk.api.db.IPersistenceUnit;
import net.as_development.asdk.db_service.impl.DB;
import net.as_development.asdk.tools.reflection.ObjectManipulation;
import net.as_development.asdk.tools.test.AssertEx;
import org.junit.Ignore;
import test.net.as_development.asdk.db_service.test.entities.TestEntity;
import test.net.as_development.asdk.db_service.test.helper.DbEnvProvider;

@Ignore
public class GenericDbTest {
    private static final int MODE_EMPTY_DB = 1;
    private static final int MODE_ENTITY_SCHEMA_AVAILABLE = 2;
    private static final boolean TEST_ID_GENERATION = true;
    private static final boolean TEST_ID_REUSING = true;
    private static final boolean TEST_SCHEMA_GENERATION = true;
    private static final boolean TEST_SCHEMA_REMOVE = true;
    private static final boolean TEST_STORING_ENTITIES = true;
    private static final boolean TEST_UPDATE_ENTITIES = true;
    private static final boolean TEST_REMOVING_ENTITIES = true;
    private static final boolean TEST_QUERING_ENTITIES = true;
    private static final boolean TEST_TYPE_MAPPING = true;
    private static final boolean TEST_PERFORMANCE = false;
    private static final boolean TEST_MODIFYSTAMP = true;
    private static final String STRINGVALUE_TEST_ENTITY_PREFIX = "test_entity";
    private static final String STRINGVALUE_TEST_ENTITY_A = "test_entity_a_";
    private static final String STRINGVALUE_TEST_ENTITY_B = "test_entity_b_";
    private static final String STRINGVALUE_TEST_ENTITY_B1 = "test_entity_b_1";
    private int m_nDbEnv = 0;
    private DbEnvProvider m_aDbEnv = null;
    private Date m_aReferenceDate = null;

    public void defineDbEnv(int nDbEnv) throws Exception {
        this.m_nDbEnv = nDbEnv;
    }

    public void testIdGeneration() throws Exception {
        try {
            IDB iDb = this.impl_setUp(2);
            TestEntity e1 = new TestEntity();
            Assert.assertNull((String)"Id of new created entity must be null.", (Object)e1.Id);
            iDb.storeEntities((IEntity[])new TestEntity[]{e1});
            Assert.assertNotNull((String)"Id of new persistent entity must not be null.", (Object)e1.Id);
        }
        finally {
            this.impl_tearDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIdReUsing() throws Exception {
        try {
            IDB iDb = this.impl_setUp(2);
            iDb.removeAllEntitiesOfType(TestEntity.class);
            String sExternalID = UUID.randomUUID().toString();
            TestEntity aEntity = new TestEntity();
            aEntity.ExternalId = sExternalID;
            iDb.storeEntities((IEntity[])new TestEntity[]{aEntity});
            Assert.assertEquals((String)"external ID seems not to be taken real", (String)sExternalID, (String)aEntity.Id);
            TestEntity aCheck = (TestEntity)iDb.getEntityById(TestEntity.class, sExternalID);
            Assert.assertNotNull((String)"can not find entity with external ID in DB", (Object)((Object)aCheck));
            Assert.assertEquals((String)"found entity for external ID but it has not the right ID set.", (String)aEntity.Id, (String)aCheck.Id);
        }
        finally {
            this.impl_tearDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSchemaCreation() throws Exception {
        try {
            IDB iDb = this.impl_setUp(1);
            TestEntity e1 = new TestEntity();
            try {
                iDb.storeEntities((IEntity[])new TestEntity[]{e1});
                Assert.fail((String)"IDB.storeEntities () does not throw an exception where entity schema was not created before.");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ((IDBSchema)iDb).createEntitySchema(TestEntity.class);
            iDb.storeEntities((IEntity[])new TestEntity[]{e1});
        }
        finally {
            this.impl_tearDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSchemaRemove() throws Exception {
        try {
            IDB iDb = this.impl_setUp(1);
            IDBSchema iCreator = (IDBSchema)iDb;
            TestEntity aEntity = new TestEntity();
            iCreator.createEntitySchema(TestEntity.class);
            iDb.storeEntities((IEntity[])new TestEntity[]{aEntity});
            iCreator.removeEntitySchema(TestEntity.class);
            iCreator.removeEntitySchema(TestEntity.class);
        }
        finally {
            this.impl_tearDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStoringEntities() throws Exception {
        try {
            IDB iDb = this.impl_setUp(2);
            int c = 10;
            TestEntity[] lEntities = new TestEntity[c];
            int i = 0;
            for (i = 0; i < c; ++i) {
                TestEntity aEntity = new TestEntity();
                aEntity.StringValue = "test_entity_nr_" + i;
                aEntity.IntValue = i;
                lEntities[i] = aEntity;
            }
            iDb.storeEntities((IEntity[])lEntities);
            for (i = 0; i < c; ++i) {
                TestEntity aOriginal = lEntities[i];
                TestEntity aCheck = (TestEntity)iDb.getEntityById(TestEntity.class, aOriginal.Id);
                Assert.assertNotSame((String)"testStoringEntities [01] original stored and by ID new retrieved entities has not to be the same object.", (Object)((Object)aOriginal), (Object)((Object)aCheck));
                Assert.assertEquals((String)"testStoringEntities [02] ... but they have to use the same ID.", (String)aOriginal.Id, (String)aCheck.Id);
            }
        }
        finally {
            this.impl_tearDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateEntities() throws Exception {
        try {
            String sValue1 = "value_1";
            String sValue2 = "value_2";
            TestEntity aEntity1 = null;
            TestEntity aCheck = null;
            IDB iDb = this.impl_setUp(2);
            aEntity1 = new TestEntity();
            aEntity1.StringValue = sValue1;
            iDb.storeEntities((IEntity[])new TestEntity[]{aEntity1});
            aCheck = (TestEntity)iDb.getEntityById(TestEntity.class, aEntity1.Id);
            AssertEx.assertEquals((String)"testUpdateEntities [01] check string value of entity after initial store.", (Object)sValue1, (Object)aCheck.StringValue);
            aEntity1.StringValue = sValue2;
            iDb.storeEntities((IEntity[])new TestEntity[]{aEntity1});
            aCheck = (TestEntity)iDb.getEntityById(TestEntity.class, aEntity1.Id);
            AssertEx.assertEquals((String)"testUpdateEntities [02] check string value of entity after update.", (Object)sValue2, (Object)aCheck.StringValue);
        }
        finally {
            this.impl_tearDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemovingEntities() throws Exception {
        try {
            IDB iDb = this.impl_setUp(2);
            int c = 10;
            TestEntity[] lEntities = new TestEntity[c];
            int i = 0;
            for (i = 0; i < c; ++i) {
                TestEntity aEntity = new TestEntity();
                aEntity.StringValue = "test_entity_nr_" + i;
                aEntity.IntValue = i;
                lEntities[i] = aEntity;
            }
            iDb.storeEntities((IEntity[])lEntities);
            String sId5 = lEntities[5].Id;
            String sId7 = lEntities[7].Id;
            iDb.removeEntities((IEntity[])new TestEntity[]{lEntities[5], lEntities[7]});
            TestEntity aCheck5 = (TestEntity)iDb.getEntityById(TestEntity.class, sId5);
            TestEntity aCheck7 = (TestEntity)iDb.getEntityById(TestEntity.class, sId7);
            AssertEx.assertFalse((String)"testRemovingEntities [01] entity '5' was removed .. but isPersistent() returns true.", (boolean)lEntities[5].isPersistent());
            AssertEx.assertFalse((String)"testRemovingEntities [02] entity '7' was removed .. but isPersistent() returns true.", (boolean)lEntities[7].isPersistent());
            AssertEx.assertNull((String)"testRemovingEntities [03] entity '5' was removed .. but it's Id was not reseted.", (Object)lEntities[5].Id);
            AssertEx.assertNull((String)"testRemovingEntities [04] entity '7' was removed .. but it's Id was not reseted.", (Object)lEntities[7].Id);
            AssertEx.assertNull((String)"testRemovingEntities [05] entity '5' was removed .. but could be retrieved afterwards.", (Object)((Object)aCheck5));
            AssertEx.assertNull((String)"testRemovingEntities [06] entity '7' was removed .. but could be retrieved afterwards.", (Object)((Object)aCheck7));
        }
        finally {
            this.impl_tearDown();
        }
    }

    public void testQueringEntities() throws Exception {
        this.impl_testMatchQueries();
        this.impl_testLikeQueries();
        this.impl_testBetweenQueries();
        this.impl_testBetweenDates();
        this.impl_testQueryPagination();
    }

    public void testTypeMapping() throws Exception {
        try {
            IDB iDb = this.impl_setUp(2);
            this.impl_checkBooleanTypeMapping(iDb);
            this.impl_checkCharTypeMapping(iDb);
            this.impl_checkByteTypeMapping(iDb);
            this.impl_checkShortTypeMapping(iDb);
            this.impl_checkIntTypeMapping(iDb);
            this.impl_checkLongTypeMapping(iDb);
            this.impl_checkDoubleTypeMapping(iDb);
            this.impl_checkFloatTypeMapping(iDb);
            this.impl_checkDateTypeMapping(iDb);
            this.impl_checkStringTypeMapping(iDb);
        }
        finally {
            this.impl_tearDown();
        }
    }

    public void testPerformance() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testModifyStamp() throws Exception {
        try {
            IDB iDb = this.impl_setUp(2);
            int c = 10;
            TestEntity[] lEntities = new TestEntity[c];
            int i = 0;
            for (i = 0; i < c; ++i) {
                TestEntity aEntity = new TestEntity();
                aEntity.StringValue = "test_entity_nr_" + i;
                aEntity.IntValue = i;
                lEntities[i] = aEntity;
            }
            iDb.storeEntities((IEntity[])lEntities);
            for (i = 0; i < c; ++i) {
                TestEntity aCheck = lEntities[i];
                Assert.assertNotNull((String)"testModifyStamp [01] modify stamp != null ?", (Object)aCheck.getModifyStamp());
            }
            TestEntity aModifyEntity = lEntities[c - 1];
            Date aLastModifyStamp = aModifyEntity.getModifyStamp();
            GenericDbTest genericDbTest = this;
            synchronized (genericDbTest) {
                this.wait(100L);
            }
            iDb.storeEntities((IEntity[])new TestEntity[]{aModifyEntity});
            Date aNewModifyStamp = aModifyEntity.getModifyStamp();
            Assert.assertTrue((String)"testModifyStamp [02] modify stamp not updated ?.", (aLastModifyStamp.getTime() != aNewModifyStamp.getTime() ? 1 : 0) != 0);
            String sNextToken = null;
            ArrayList lResults = new ArrayList(10);
            IDBQuery iQuery = iDb.prepareQuery(TestEntity.class, "query_for_modify_stamp");
            iQuery.setQueryPart(0, EQueryPartBinding.E_AND, EQueryPartOperation.E_GREATER_THAN, "modify_stamp", (Object)aLastModifyStamp);
            iDb.query(TestEntity.class, sNextToken, lResults, iQuery);
            Assert.assertTrue((String)"testModifyStamp [03] unexpected size for result set", (lResults.size() == 1 ? 1 : 0) != 0);
            Assert.assertEquals((String)"testModifyStamp [04] unexpected entity in query result", (String)aModifyEntity.Id, (String)((TestEntity)((Object)lResults.get((int)0))).Id);
        }
        finally {
            this.impl_tearDown();
        }
    }

    private void impl_checkBooleanTypeMapping(IDB iDb) throws Exception {
        this.impl_checkNullMapping("testTypeMapping - Boolean [01] check null", iDb, "BooleanValue");
        this.impl_checkTypeMapping("testTypeMapping - Boolean [01] check 'false'", iDb, "BooleanValue", Boolean.FALSE);
        this.impl_checkTypeMapping("testTypeMapping - Boolean [02] check 'true'", iDb, "BooleanValue", Boolean.TRUE);
        this.impl_checkTypeMapping("testTypeMapping - boolean [03] check 'false'", iDb, "SimpleBooleanValue", false);
        this.impl_checkTypeMapping("testTypeMapping - boolean [04] check 'true'", iDb, "SimpleBooleanValue", true);
    }

    private void impl_checkCharTypeMapping(IDB iDb) throws Exception {
        this.impl_checkTypeMapping("testTypeMapping - Char [01] check ' '", iDb, "CharValue", Character.valueOf(' '));
        this.impl_checkTypeMapping("testTypeMapping - Char [02] check '#'", iDb, "CharValue", Character.valueOf('#'));
        this.impl_checkTypeMapping("testTypeMapping - Char [03] check '\u00f6'", iDb, "CharValue", Character.valueOf('\u00f6'));
    }

    private void impl_checkByteTypeMapping(IDB iDb) throws Exception {
        this.impl_checkNullMapping("testTypeMapping - Byte [01] check null", iDb, "ByteValue");
        this.impl_checkTypeMapping("testTypeMapping - Byte [02] check 'min'", iDb, "ByteValue", (byte)-128);
        this.impl_checkTypeMapping("testTypeMapping - Byte [03] check '-100'", iDb, "ByteValue", (byte)-100);
        this.impl_checkTypeMapping("testTypeMapping - Byte [04] check '0'", iDb, "ByteValue", (byte)0);
        this.impl_checkTypeMapping("testTypeMapping - Byte [05] check '100'", iDb, "ByteValue", (byte)100);
        this.impl_checkTypeMapping("testTypeMapping - Byte [06] check 'max'", iDb, "ByteValue", (byte)127);
        this.impl_checkTypeMapping("testTypeMapping - byte [07] check 'min'", iDb, "SimpleByteValue", (byte)-128);
        this.impl_checkTypeMapping("testTypeMapping - byte [08] check '-100'", iDb, "SimpleByteValue", (byte)-100);
        this.impl_checkTypeMapping("testTypeMapping - byte [09] check '0'", iDb, "SimpleByteValue", (byte)0);
        this.impl_checkTypeMapping("testTypeMapping - byte [10] check '100'", iDb, "SimpleByteValue", (byte)100);
        this.impl_checkTypeMapping("testTypeMapping - byte [11] check 'max'", iDb, "SimpleByteValue", (byte)127);
    }

    private void impl_checkShortTypeMapping(IDB iDb) throws Exception {
        this.impl_checkNullMapping("testTypeMapping - Short [01] check null", iDb, "ShortValue");
        this.impl_checkTypeMapping("testTypeMapping - Short [02] check 'min'", iDb, "ShortValue", (short)Short.MIN_VALUE);
        this.impl_checkTypeMapping("testTypeMapping - Short [03] check '-100'", iDb, "ShortValue", (short)-100);
        this.impl_checkTypeMapping("testTypeMapping - Short [04] check '0'", iDb, "ShortValue", (short)0);
        this.impl_checkTypeMapping("testTypeMapping - Short [05] check '100'", iDb, "ShortValue", (short)100);
        this.impl_checkTypeMapping("testTypeMapping - Short [06] check 'max'", iDb, "ShortValue", (short)Short.MAX_VALUE);
        this.impl_checkTypeMapping("testTypeMapping - short [07] check 'min'", iDb, "SimpleShortValue", (short)Short.MIN_VALUE);
        this.impl_checkTypeMapping("testTypeMapping - short [08] check '-100'", iDb, "SimpleShortValue", (short)-100);
        this.impl_checkTypeMapping("testTypeMapping - short [09] check '0'", iDb, "SimpleShortValue", (short)0);
        this.impl_checkTypeMapping("testTypeMapping - short [10] check '100'", iDb, "SimpleShortValue", (short)100);
        this.impl_checkTypeMapping("testTypeMapping - short [11] check 'max'", iDb, "SimpleShortValue", (short)Short.MAX_VALUE);
    }

    private void impl_checkIntTypeMapping(IDB iDb) throws Exception {
        this.impl_checkNullMapping("testTypeMapping - Integer [01] check null", iDb, "IntValue");
        this.impl_checkTypeMapping("testTypeMapping - Integer [02] check 'min'", iDb, "IntValue", Integer.MIN_VALUE);
        this.impl_checkTypeMapping("testTypeMapping - Integer [03] check '-100'", iDb, "IntValue", -100);
        this.impl_checkTypeMapping("testTypeMapping - Integer [04] check '0'", iDb, "IntValue", 0);
        this.impl_checkTypeMapping("testTypeMapping - Integer [05] check '100'", iDb, "IntValue", 100);
        this.impl_checkTypeMapping("testTypeMapping - Integer [06] check 'max'", iDb, "IntValue", Integer.MAX_VALUE);
        this.impl_checkTypeMapping("testTypeMapping - int     [07] check 'min'", iDb, "SimpleIntValue", Integer.MIN_VALUE);
        this.impl_checkTypeMapping("testTypeMapping - int     [08] check '-100'", iDb, "SimpleIntValue", -100);
        this.impl_checkTypeMapping("testTypeMapping - int     [09] check '0'", iDb, "SimpleIntValue", 0);
        this.impl_checkTypeMapping("testTypeMapping - int     [10] check '100'", iDb, "SimpleIntValue", 100);
        this.impl_checkTypeMapping("testTypeMapping - int     [11] check 'max'", iDb, "SimpleIntValue", Integer.MAX_VALUE);
    }

    private void impl_checkLongTypeMapping(IDB iDb) throws Exception {
        this.impl_checkNullMapping("testTypeMapping - Long [01] check null", iDb, "LongValue");
        this.impl_checkTypeMapping("testTypeMapping - Long [02] check 'min'", iDb, "LongValue", Long.MIN_VALUE);
        this.impl_checkTypeMapping("testTypeMapping - Long [03] check '-100'", iDb, "LongValue", -100L);
        this.impl_checkTypeMapping("testTypeMapping - Long [04] check '0'", iDb, "LongValue", 0L);
        this.impl_checkTypeMapping("testTypeMapping - Long [05] check '100'", iDb, "LongValue", 100L);
        this.impl_checkTypeMapping("testTypeMapping - Long [06] check 'max'", iDb, "LongValue", Long.MAX_VALUE);
        this.impl_checkTypeMapping("testTypeMapping - long [07] check 'min'", iDb, "SimpleLongValue", Long.MIN_VALUE);
        this.impl_checkTypeMapping("testTypeMapping - long [08] check '-100'", iDb, "SimpleLongValue", -100L);
        this.impl_checkTypeMapping("testTypeMapping - long [09] check '0'", iDb, "SimpleLongValue", 0L);
        this.impl_checkTypeMapping("testTypeMapping - long [10] check '100'", iDb, "SimpleLongValue", 100L);
        this.impl_checkTypeMapping("testTypeMapping - long [11] check 'max'", iDb, "SimpleLongValue", Long.MAX_VALUE);
    }

    private void impl_checkDoubleTypeMapping(IDB iDb) throws Exception {
        double MIN = Double.MIN_VALUE;
        double MAX = Double.MAX_VALUE;
        if (this.m_nDbEnv == 1) {
            MIN = -1.79769E308;
            MAX = 1.79769E308;
        }
        this.impl_checkNullMapping("testTypeMapping - Double [01] check null", iDb, "DoubleValue");
        this.impl_checkTypeMapping("testTypeMapping - Double [02] check 'min'", iDb, "DoubleValue", MIN);
        this.impl_checkTypeMapping("testTypeMapping - Double [03] check '-100.78'", iDb, "DoubleValue", -100.78);
        this.impl_checkTypeMapping("testTypeMapping - Double [04] check '0.0'", iDb, "DoubleValue", 0.0);
        this.impl_checkTypeMapping("testTypeMapping - Double [05] check '100.4633'", iDb, "DoubleValue", 100.4633);
        this.impl_checkTypeMapping("testTypeMapping - Double [06] check 'max'", iDb, "DoubleValue", MAX);
        this.impl_checkTypeMapping("testTypeMapping - double [07] check 'min'", iDb, "SimpleDoubleValue", MIN);
        this.impl_checkTypeMapping("testTypeMapping - double [08] check '-90.1967'", iDb, "SimpleDoubleValue", -90.1967);
        this.impl_checkTypeMapping("testTypeMapping - double [09] check '0.0'", iDb, "SimpleDoubleValue", 0.0);
        this.impl_checkTypeMapping("testTypeMapping - double [10] check '100.1674'", iDb, "SimpleDoubleValue", 100.1674);
        this.impl_checkTypeMapping("testTypeMapping - double [11] check 'max'", iDb, "SimpleDoubleValue", MAX);
    }

    private void impl_checkFloatTypeMapping(IDB iDb) throws Exception {
        this.impl_checkNullMapping("testTypeMapping - Float [01] check null", iDb, "FloatValue");
        this.impl_checkTypeMapping("testTypeMapping - Float [02] check 'min'", iDb, "FloatValue", Float.valueOf(Float.MIN_VALUE));
        this.impl_checkTypeMapping("testTypeMapping - Float [03] check '-100.78'", iDb, "FloatValue", Float.valueOf(-100.78f));
        this.impl_checkTypeMapping("testTypeMapping - Float [04] check '0.0'", iDb, "FloatValue", Float.valueOf(0.0f));
        this.impl_checkTypeMapping("testTypeMapping - Float [05] check '100.4633'", iDb, "FloatValue", Float.valueOf(100.4633f));
        this.impl_checkTypeMapping("testTypeMapping - Float [06] check 'max'", iDb, "FloatValue", Float.valueOf(Float.MAX_VALUE));
        this.impl_checkTypeMapping("testTypeMapping - float [07] check 'min'", iDb, "SimpleFloatValue", Float.valueOf(Float.MIN_VALUE));
        this.impl_checkTypeMapping("testTypeMapping - float [08] check '-90.1967'", iDb, "SimpleFloatValue", Float.valueOf(-90.1967f));
        this.impl_checkTypeMapping("testTypeMapping - float [09] check '0.0'", iDb, "SimpleFloatValue", Float.valueOf(0.0f));
        this.impl_checkTypeMapping("testTypeMapping - float [10] check '100.1674'", iDb, "SimpleFloatValue", Float.valueOf(100.1674f));
        this.impl_checkTypeMapping("testTypeMapping - float [11] check 'max'", iDb, "SimpleFloatValue", Float.valueOf(Float.MAX_VALUE));
    }

    private void impl_checkStringTypeMapping(IDB iDb) throws Exception {
        this.impl_checkNullMapping("testTypeMapping - String [01] check null", iDb, "StringValue");
        this.impl_checkTypeMapping("testTypeMapping - String [02] check ''", iDb, "StringValue", "");
        this.impl_checkTypeMapping("testTypeMapping - String [03] check ' '", iDb, "StringValue", " ");
        this.impl_checkTypeMapping("testTypeMapping - String [04] check 'any string you like'", iDb, "StringValue", "any string you like");
        this.impl_checkTypeMapping("testTypeMapping - String [04] check '\u00f6\u00e4\u00fc\u00df#+\u00b4!\u00a7$%&/()=?'", iDb, "StringValue", "\u00f6\u00e4\u00fc\u00df#+\u00b4!\u00a7$%&/()=?");
        this.impl_checkTypeMapping("testTypeMapping - String [04] check '\n\t\r\\\"", iDb, "StringValue", "\n\t\r\\\"");
    }

    private void impl_checkDateTypeMapping(IDB iDb) throws Exception {
        this.impl_checkNullMapping("testTypeMapping - Date [01] check null", iDb, "DateValue");
        this.impl_checkTypeMapping("testTypeMapping - Date [02] check real Date", iDb, "DateValue", new Date());
    }

    private void impl_checkTypeMapping(String sErrorMessage, IDB iDb, String sEntityField, Object aValue) throws Exception {
        TestEntity aEntity = new TestEntity();
        ObjectManipulation.setFieldValue((Object)((Object)aEntity), (String)sEntityField, (Object)aValue);
        iDb.storeEntities((IEntity[])new TestEntity[]{aEntity});
        TestEntity aCheckEntity = (TestEntity)iDb.getEntityById(TestEntity.class, aEntity.Id);
        Object aCheckValue = ObjectManipulation.getFieldValue((Object)((Object)aCheckEntity), (String)sEntityField);
        AssertEx.assertEquals((String)sErrorMessage, (Object)aCheckValue, (Object)aValue);
    }

    private void impl_checkNullMapping(String sErrorMessage, IDB iDb, String sEntityField) throws Exception {
        TestEntity aEntity = new TestEntity();
        ObjectManipulation.setFieldValue((Object)((Object)aEntity), (String)sEntityField, (Object)null);
        iDb.storeEntities((IEntity[])new TestEntity[]{aEntity});
        TestEntity aCheckEntity = (TestEntity)iDb.getEntityById(TestEntity.class, aEntity.Id);
        Object aCheckValue = ObjectManipulation.getFieldValue((Object)((Object)aCheckEntity), (String)sEntityField);
        AssertEx.assertNull((String)sErrorMessage, (Object)aCheckValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void impl_testMatchQueries() throws Exception {
        try {
            IDB iDb = this.impl_createTestDbForQueries(20);
            ArrayList lResults = new ArrayList();
            IDBQuery iQuery = null;
            String sFirstNextToken = null;
            iQuery = iDb.prepareQuery(TestEntity.class, "match_a");
            iQuery.setQueryPart(0, EQueryPartBinding.E_AND, EQueryPartOperation.E_MATCH, "BooleanValue", (Object)true);
            iDb.query(TestEntity.class, sFirstNextToken, lResults, iQuery);
            AssertEx.assertEquals((String)"testMatchQueries [a_01] expect 10 results", (long)10L, (long)lResults.size());
            for (TestEntity aResult : lResults) {
                AssertEx.assertTrue((String)"testMatchQueries [a_02] check if boolean value is TRUE ...", (aResult.BooleanValue == true ? 1 : 0) != 0);
            }
            iQuery = iDb.prepareQuery(TestEntity.class, "match_b");
            iQuery.setQueryPart(0, EQueryPartBinding.E_OR, EQueryPartOperation.E_MATCH, "IntValue", (Object)1);
            iQuery.setQueryPart(1, EQueryPartBinding.E_OR, EQueryPartOperation.E_MATCH, "IntValue", (Object)5);
            iQuery.setQueryPart(2, EQueryPartBinding.E_OR, EQueryPartOperation.E_MATCH, "IntValue", (Object)7);
            iQuery.setQueryPart(3, EQueryPartBinding.E_OR, EQueryPartOperation.E_MATCH, "IntValue", (Object)18);
            iDb.query(TestEntity.class, sFirstNextToken, lResults, iQuery);
            AssertEx.assertEquals((String)"testMatchQueries [b_01] expect 4 results", (long)4L, (long)lResults.size());
            ArrayList<Integer> lIntResults = new ArrayList<Integer>(4);
            for (TestEntity aResult : lResults) {
                lIntResults.add(aResult.IntValue);
            }
            AssertEx.assertTrue((String)"testMatchQueries [b_02] check for integer result '1' ...", (boolean)lIntResults.contains(1));
            AssertEx.assertTrue((String)"testMatchQueries [b_03] check for integer result '5' ...", (boolean)lIntResults.contains(5));
            AssertEx.assertTrue((String)"testMatchQueries [b_04] check for integer result '7' ...", (boolean)lIntResults.contains(7));
            AssertEx.assertTrue((String)"testMatchQueries [b_05] check for integer result '18' ...", (boolean)lIntResults.contains(18));
        }
        finally {
            this.impl_tearDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void impl_testLikeQueries() throws Exception {
        try {
            IDB iDb = this.impl_createTestDbForQueries(20);
            ArrayList lResults = new ArrayList();
            IDBQuery iQuery = null;
            String sFirstNextToken = null;
            iQuery = iDb.prepareQuery(TestEntity.class, "like_a");
            iQuery.setQueryPart(0, EQueryPartBinding.E_AND, EQueryPartOperation.E_LIKE, "StringValue", (Object)"*_b_*");
            iDb.query(TestEntity.class, sFirstNextToken, lResults, iQuery);
            AssertEx.assertEquals((String)"testLikeQueries [a_01] expect 10 results", (long)10L, (long)lResults.size());
            for (TestEntity aResult : lResults) {
                AssertEx.assertTrue((String)"testLikeQueries [a_02] check if string value match ...", (boolean)aResult.StringValue.startsWith(STRINGVALUE_TEST_ENTITY_B));
            }
            iQuery = iDb.prepareQuery(TestEntity.class, "like_b");
            iQuery.setQueryPart(0, EQueryPartBinding.E_AND, EQueryPartOperation.E_LIKE, "StringValue", (Object)"test_entity_b_1?");
            iDb.query(TestEntity.class, sFirstNextToken, lResults, iQuery);
            AssertEx.assertEquals((String)"testLikeQueries [b_01] expect 10 results", (long)10L, (long)lResults.size());
            for (TestEntity aResult : lResults) {
                AssertEx.assertTrue((String)"testLikeQueries [b_02] check if string value match ...", (boolean)aResult.StringValue.startsWith(STRINGVALUE_TEST_ENTITY_B1));
            }
        }
        finally {
            this.impl_tearDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void impl_testBetweenQueries() throws Exception {
        try {
            IDB iDb = this.impl_createTestDbForQueries(20);
            ArrayList lResults = new ArrayList();
            IDBQuery iQuery = null;
            String sFirstNextToken = null;
            int nMin = 8;
            int nMax = 11;
            iQuery = iDb.prepareQuery(TestEntity.class, "between_8_and_11");
            iQuery.setQueryPart(0, EQueryPartBinding.E_AND, EQueryPartOperation.E_BETWEEN, "IntValue", (Object)new BetweenQueryRange((Object)nMin, (Object)nMax));
            iDb.query(TestEntity.class, sFirstNextToken, lResults, iQuery);
            AssertEx.assertEquals((String)"testBetweenQueries [a_01] expect 4 results", (long)4L, (long)lResults.size());
            for (TestEntity aResult : lResults) {
                AssertEx.assertTrue((String)"testBetweenQueries [a_02] check if int value match ...", (aResult.IntValue >= nMin && aResult.IntValue <= nMax ? 1 : 0) != 0);
            }
        }
        finally {
            this.impl_tearDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void impl_testBetweenDates() throws Exception {
        try {
            IDB iDb = this.impl_createTestDbForQueries(20);
            ArrayList lResults = new ArrayList();
            IDBQuery iQuery = null;
            String sFirstNextToken = null;
            long nReferenceDate = this.m_aReferenceDate.getTime();
            long nMin = nReferenceDate + 8L;
            long nMax = nReferenceDate + 11L;
            Date aMin = new Date(nMin);
            Date aMax = new Date(nMax);
            iQuery = iDb.prepareQuery(TestEntity.class, "between_date_8_and_date_11");
            iQuery.setQueryPart(0, EQueryPartBinding.E_AND, EQueryPartOperation.E_BETWEEN, "DateValue", (Object)new BetweenQueryRange((Object)aMin, (Object)aMax));
            iDb.query(TestEntity.class, sFirstNextToken, lResults, iQuery);
            AssertEx.assertEquals((String)"testBetweenDates [01] expect 4 results", (long)4L, (long)lResults.size());
            for (TestEntity aResult : lResults) {
                AssertEx.assertTrue((String)"testBetweenQueries [02] check if Date value is between ...", (aResult.DateValue.getTime() >= nMin && aResult.DateValue.getTime() <= nMax ? 1 : 0) != 0);
            }
        }
        finally {
            this.impl_tearDown();
        }
    }

    private void impl_testQueryPagination() throws Exception {
    }

    private IDB impl_setUp(int nMode) throws Exception {
        this.m_aDbEnv = new DbEnvProvider();
        this.m_aDbEnv.setUp(this.m_nDbEnv);
        DB iDb = new DB();
        iDb.setPersistenceUnit((IPersistenceUnit)this.m_aDbEnv.getPersistenceUnit());
        iDb.removeEntitySchema(TestEntity.class);
        if (nMode == 2) {
            iDb.createEntitySchema(TestEntity.class);
        }
        return iDb;
    }

    private void impl_tearDown() throws Exception {
        if (this.m_aDbEnv != null) {
            this.m_aDbEnv.tearDown(this.m_nDbEnv);
        }
        this.m_aDbEnv = null;
    }

    private IDB impl_createTestDbForQueries(int nCount) throws Exception {
        IDB iDb = this.impl_setUp(2);
        int c = nCount;
        int i = 0;
        TestEntity[] lEntities = new TestEntity[c];
        this.m_aReferenceDate = new Date();
        long nReferenceDate = this.m_aReferenceDate.getTime();
        for (i = 0; i < c; ++i) {
            TestEntity aEntity = new TestEntity();
            aEntity.IntValue = i;
            aEntity.BooleanValue = i % 2 == 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
            aEntity.DateValue = new Date(nReferenceDate + (long)i);
            aEntity.StringValue = i < 10 ? STRINGVALUE_TEST_ENTITY_A : STRINGVALUE_TEST_ENTITY_B;
            aEntity.StringValue = aEntity.StringValue + i;
            lEntities[i] = aEntity;
        }
        iDb.storeEntities((IEntity[])lEntities);
        return iDb;
    }
}

