/*
 * Decompiled with CFR 0.152.
 */
package test.net.as_development.asdk.db_service.test.helper;

import net.as_development.asdk.api.sql.ISqlServer;
import net.as_development.asdk.db_service.impl.PersistenceUnit;
import net.as_development.asdk.db_service.impl.backend.mongodb.MongoDbProvider;
import net.as_development.asdk.db_service.impl.sql.SqlProvider;
import net.as_development.asdk.sql.server.impl.EmbeddedDerbyServer;
import org.junit.Ignore;
import test.net.as_development.asdk.db_service.test.entities.TestEntity;

@Ignore
public class DbEnvProvider {
    public static final int ENV_EMBEDDED_SQL = 1;
    public static final int ENV_REMOTE_SQL = 2;
    public static final int ENV_AMAZON_SIMPLEDB = 3;
    public static final int ENV_MONGODB = 4;
    private ISqlServer m_iSqlServer;
    private PersistenceUnit m_aPersistenceUnit = null;

    public void setUp(int nEnv) throws Exception {
        switch (nEnv) {
            case 1: {
                this.impl_setUpEmbeddedSql();
                break;
            }
            case 2: {
                this.impl_setUpRemoteSql();
                break;
            }
            case 3: {
                this.impl_setUpAmazonSimpleDb();
                break;
            }
            case 4: {
                this.impl_setUpMongoDb();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported environment id specified.");
            }
        }
    }

    public void tearDown(int nEnv) throws Exception {
        switch (nEnv) {
            case 1: {
                this.impl_tearDownEmbeddedSql();
                break;
            }
            case 2: {
                this.impl_tearDownRemoteSql();
                break;
            }
            case 3: {
                this.impl_tearDownAmazonSimpleDb();
                break;
            }
            case 4: {
                this.impl_tearDownMongoDb();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported environment id specified.");
            }
        }
    }

    public PersistenceUnit getPersistenceUnit() throws Exception {
        return this.m_aPersistenceUnit;
    }

    private void impl_setUpEmbeddedSql() throws Exception {
        System.out.println("set up db env for 'embedded sql' ...");
        EmbeddedDerbyServer iServer = new EmbeddedDerbyServer();
        PersistenceUnit aUnit = new PersistenceUnit();
        aUnit.setName("embedded_sql");
        aUnit.setProvider(SqlProvider.class.getName());
        aUnit.addEntity(TestEntity.class.getName());
        aUnit.setProperty("jdbc.driver", iServer.getDriverClass());
        aUnit.setProperty("db.user", iServer.getUser());
        aUnit.setProperty("db.password", iServer.getPassword());
        aUnit.setProperty("jdbc.connection.url", iServer.getConnectionUrl());
        aUnit.setProperty("cacheprovider.db_implementation", SqlProvider.class.getName());
        this.m_iSqlServer = iServer;
        this.m_aPersistenceUnit = aUnit;
        System.out.println("start server ...");
        iServer.start();
        System.out.println("OK");
    }

    private void impl_setUpRemoteSql() throws Exception {
        System.out.println("set up db env for 'remote sql' (postgresql at localhost) ...");
        PersistenceUnit aUnit = new PersistenceUnit();
        aUnit.setName("remote_sql");
        aUnit.setProvider(SqlProvider.class.getName());
        aUnit.addEntity(TestEntity.class.getName());
        aUnit.setProperty("jdbc.driver", "org.postgresql.Driver");
        aUnit.setProperty("db.user", "postgres");
        aUnit.setProperty("db.password", "xxx");
        aUnit.setProperty("jdbc.connection.url", "jdbc:postgresql://localhost/postgres");
        this.m_iSqlServer = null;
        this.m_aPersistenceUnit = aUnit;
        System.out.println("OK");
    }

    private void impl_setUpAmazonSimpleDb() throws Exception {
        throw new UnsupportedOperationException("fix me");
    }

    private void impl_setUpMongoDb() throws Exception {
        System.out.println("set up db env for 'MongoDB' ...");
        PersistenceUnit aUnit = new PersistenceUnit();
        aUnit.setName("mongodb");
        aUnit.setProvider(MongoDbProvider.class.getName());
        aUnit.addEntity(TestEntity.class.getName());
        String sServer = null;
        sServer = "192.168.1.191";
        sServer = "129.157.138.48";
        aUnit.setProperty("db.schema", "db-sevice-mongodb-unit-test");
        aUnit.setProperty("mongodb.server", sServer);
        aUnit.setProperty("mongodb.port", "27017");
        this.m_iSqlServer = null;
        this.m_aPersistenceUnit = aUnit;
        System.out.println("OK");
    }

    private void impl_tearDownEmbeddedSql() throws Exception {
        System.out.println("tear down db env for 'embedded sql' ...");
        ISqlServer iServer = this.m_iSqlServer;
        this.m_iSqlServer = null;
        this.m_aPersistenceUnit = null;
        System.out.println("stop server ...");
        iServer.stop();
        System.out.println("OK");
    }

    private void impl_tearDownRemoteSql() throws Exception {
        System.out.println("tear down db env for 'remote SQL' ...");
        this.m_iSqlServer = null;
        this.m_aPersistenceUnit = null;
    }

    private void impl_tearDownAmazonSimpleDb() throws Exception {
        System.out.println("tear down db env for 'Amazon SimpleDB' ...");
        this.m_iSqlServer = null;
        this.m_aPersistenceUnit = null;
    }

    private void impl_tearDownMongoDb() throws Exception {
        System.out.println("tear down db env for 'MongoDB' ...");
        this.m_iSqlServer = null;
        this.m_aPersistenceUnit = null;
    }
}

