/*
 * Decompiled with CFR 0.152.
 */
package test.net.as_development.asdk.db_service.impl.sql;

import java.sql.PreparedStatement;
import net.as_development.asdk.db_service.IDBBackendQuery;
import net.as_development.asdk.db_service.ISqlGenerator;
import net.as_development.asdk.db_service.impl.Row;
import net.as_development.asdk.db_service.impl.sql.SqlStatementCache;
import net.as_development.asdk.tools.test.AssertEx;
import org.junit.Test;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;

public class SqlStatementCacheTest {
    @Test
    public void testBuildCacheId() throws Exception {
        SqlStatementCache aCache = new SqlStatementCache();
        Row aMetaMock = (Row)PowerMockito.mock(Row.class);
        IDBBackendQuery iQueryMock = (IDBBackendQuery)PowerMockito.mock(IDBBackendQuery.class);
        this.impl_testBuildCacheId(aCache, aMetaMock, iQueryMock, "my_table", ISqlGenerator.EStatementType.E_INSERT, "my_query", "my_table_E_INSERT_my_query");
        this.impl_testBuildCacheId(aCache, aMetaMock, null, "my_table", ISqlGenerator.EStatementType.E_INSERT, "my_query", "my_table_E_INSERT");
    }

    private void impl_testBuildCacheId(SqlStatementCache aCache, Row aMetaMock, IDBBackendQuery iQueryMock, String sTable, ISqlGenerator.EStatementType eStatement, String sQueryId, String sExpectedCacheId) throws Exception {
        Mockito.when((Object)aMetaMock.getTable()).thenReturn((Object)sTable);
        if (iQueryMock != null) {
            Mockito.when((Object)iQueryMock.getId()).thenReturn((Object)sQueryId);
        }
        String sCacheId = aCache.buildCacheId(eStatement, aMetaMock, iQueryMock);
        AssertEx.assertEquals((String)"testBuildCacheId failed", (Object)sExpectedCacheId, (Object)sCacheId);
    }

    @Test
    public void testClear() throws Exception {
        SqlStatementCache aCache = new SqlStatementCache();
        int c = 10;
        int i = 0;
        PreparedStatement[] lStatementMocks = new PreparedStatement[c];
        for (i = 0; i < c; ++i) {
            String sCacheId = "id_" + i;
            PreparedStatement aStatementMock = (PreparedStatement)PowerMockito.mock(PreparedStatement.class);
            aCache.put((Object)sCacheId, (Object)aStatementMock);
            if (i <= c / 2) {
                ((PreparedStatement)Mockito.doThrow((Throwable)new RuntimeException()).when((Object)aStatementMock)).close();
            }
            lStatementMocks[i] = aStatementMock;
        }
        aCache.clear();
        AssertEx.assertEquals((String)"testClear [01] expect an empty cache.", (long)0L, (long)aCache.size());
    }
}

