/*
 * Decompiled with CFR 0.152.
 */
package test.net.as_development.asdk.db_service.impl.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Vector;
import net.as_development.asdk.db_service.IDBBackendQuery;
import net.as_development.asdk.db_service.ISqlGenerator;
import net.as_development.asdk.db_service.impl.EntityMetaInfo;
import net.as_development.asdk.db_service.impl.Row;
import net.as_development.asdk.db_service.impl.sql.SqlProvider;
import net.as_development.asdk.db_service.impl.sql.SqlStatementCache;
import net.as_development.asdk.tools.reflection.ObjectManipulation;
import net.as_development.asdk.tools.test.AssertEx;
import org.junit.Test;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;

public class SqlProviderTest {
    @Test
    public void testResetOfBrokenConnection() throws Exception {
        SqlProvider aSql = new SqlProvider();
        Connection aConnection = (Connection)PowerMockito.mock(Connection.class);
        Connection aCheck = null;
        String sConnectionMember = "m_aConnection";
        String sTestMethod = "impl_resetConnectionIfBroken";
        PowerMockito.when((Object)aConnection.isClosed()).thenReturn((Object)false);
        PowerMockito.when((Object)aConnection.isValid(Mockito.anyInt())).thenReturn((Object)true);
        ObjectManipulation.setFieldValue((Object)aSql, (String)sConnectionMember, (Object)aConnection);
        ObjectManipulation.callPrivateMethod((Object)aSql, (String)sTestMethod, (Object[])new Object[0]);
        aCheck = (Connection)ObjectManipulation.getFieldValue((Object)aSql, (String)sConnectionMember);
        AssertEx.assertSame((String)"testResetOfBrokenConnection [01] valid connection -> no reset", (Object)aConnection, (Object)aCheck);
        PowerMockito.when((Object)aConnection.isClosed()).thenReturn((Object)true);
        PowerMockito.when((Object)aConnection.isValid(Mockito.anyInt())).thenReturn((Object)true);
        ObjectManipulation.setFieldValue((Object)aSql, (String)sConnectionMember, (Object)aConnection);
        ObjectManipulation.callPrivateMethod((Object)aSql, (String)sTestMethod, (Object[])new Object[0]);
        aCheck = (Connection)ObjectManipulation.getFieldValue((Object)aSql, (String)sConnectionMember);
        AssertEx.assertNull((String)"testResetOfBrokenConnection [02] closed connection -> reset", (Object)aCheck);
        PowerMockito.when((Object)aConnection.isClosed()).thenReturn((Object)false);
        PowerMockito.when((Object)aConnection.isValid(Mockito.anyInt())).thenReturn((Object)false);
        ObjectManipulation.setFieldValue((Object)aSql, (String)sConnectionMember, (Object)aConnection);
        ObjectManipulation.callPrivateMethod((Object)aSql, (String)sTestMethod, (Object[])new Object[0]);
        aCheck = (Connection)ObjectManipulation.getFieldValue((Object)aSql, (String)sConnectionMember);
        AssertEx.assertNull((String)"testResetOfBrokenConnection [03] invalid connection -> reset", (Object)aCheck);
    }

    @Test
    public void testResetOfClosedPreparedStatements() throws Exception {
        SqlStatementCache aSqlCache = new SqlStatementCache();
        SqlProvider aSqlProvider = new SqlProvider();
        String sConnectionMember = "m_aConnection";
        String sCacheMember = "m_aSqlCache";
        String sTestMethod = "impl_getSql";
        Connection aConnection = (Connection)PowerMockito.mock(Connection.class);
        EntityMetaInfo aMetaInfo = (EntityMetaInfo)PowerMockito.mock(EntityMetaInfo.class);
        Row aMeta = (Row)PowerMockito.mock(Row.class);
        IDBBackendQuery iQuery = (IDBBackendQuery)PowerMockito.mock(IDBBackendQuery.class);
        ISqlGenerator.EStatementType eSqlFunc = ISqlGenerator.EStatementType.E_CREATE_TABLE;
        PreparedStatement aStatement1 = (PreparedStatement)PowerMockito.mock(PreparedStatement.class);
        PreparedStatement aStatement2 = (PreparedStatement)PowerMockito.mock(PreparedStatement.class);
        String sStatementId = aSqlCache.buildCacheId(eSqlFunc, aMeta, iQuery);
        PowerMockito.when((Object)aStatement1.isClosed()).thenReturn((Object)true);
        PowerMockito.when((Object)aStatement2.isClosed()).thenReturn((Object)false);
        PowerMockito.when((Object)aConnection.isClosed()).thenReturn((Object)false);
        PowerMockito.when((Object)aConnection.isValid(Mockito.anyInt())).thenReturn((Object)true);
        PowerMockito.when((Object)aConnection.prepareStatement(Mockito.anyString())).thenReturn((Object)aStatement2);
        PowerMockito.when((Object)aConnection.prepareStatement(Mockito.anyString(), Mockito.anyInt(), Mockito.anyInt())).thenReturn((Object)aStatement2);
        PowerMockito.when((Object)aMeta.getEntityMetaInfo()).thenReturn((Object)aMetaInfo);
        PowerMockito.when((Object)aMeta.listColumns()).thenReturn(new Vector().iterator());
        PowerMockito.when((Object)aMetaInfo.getSchema()).thenReturn((Object)"test_schema");
        aSqlCache.put((Object)sStatementId, (Object)aStatement1);
        ObjectManipulation.setFieldValue((Object)aSqlProvider, (String)sConnectionMember, (Object)aConnection);
        ObjectManipulation.setFieldValue((Object)aSqlProvider, (String)sCacheMember, (Object)aSqlCache);
        PreparedStatement aResultStatement = (PreparedStatement)ObjectManipulation.callPrivateMethod((Object)aSqlProvider, (String)sTestMethod, (Object[])new Object[]{eSqlFunc, aMeta, iQuery});
        AssertEx.assertNotNull((String)"testResetOfClosedPreparedStatements [01] resulting statement has not to be null.", (Object)aResultStatement);
        AssertEx.assertEquals((String)"testResetOfClosedPreparedStatements [02] resulting statement isnt the expected one.", (Object)aStatement2, (Object)aResultStatement);
    }
}

