/*
 * Decompiled with CFR 0.152.
 */
package test.net.as_development.asdk.db_service.impl.sql;

import net.as_development.asdk.db_service.EntityBase;
import net.as_development.asdk.db_service.ISqlGenerator;
import net.as_development.asdk.db_service.impl.EntityClassParserAnnotations;
import net.as_development.asdk.db_service.impl.EntityHelper;
import net.as_development.asdk.db_service.impl.EntityMetaInfo;
import net.as_development.asdk.db_service.impl.Row;
import net.as_development.asdk.db_service.impl.sql.generator.AnsiSqlGenerator;
import net.as_development.asdk.tools.reflection.ObjectManipulation;
import net.as_development.asdk.tools.test.AssertEx;
import org.apache.commons.lang3.StringUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.modules.junit4.PowerMockRunner;
import test.net.as_development.asdk.db_service.test.entities.TestEntity;

@RunWith(value=PowerMockRunner.class)
public class AnsiSqlGeneratorTest {
    private static final String TEST_DB_SCHEMA = "test_schema";
    private static final String TABLE_NAME = "\"test_schema\".\"ttest_entity\"";
    private static final String COLUMN_CHAR = "\"cchar_value\" varchar(1)";
    private static final String COLUMN_STRING = "\"cstring_value\" varchar(40)";
    private static final String COLUMN_BOOLEAN = "\"cboolean_value\" numeric(1,0)";
    private static final String COLUMN_SIMPLEBOOLEAN = "\"csimple_boolean_value\" numeric(1,0)";
    private static final String COLUMN_BYTE = "\"cbyte_value\" numeric(3,0)";
    private static final String COLUMN_SIMPLEBYTE = "\"csimple_byte_value\" numeric(3,0)";
    private static final String COLUMN_SHORT = "\"cshort_value\" numeric(5,0)";
    private static final String COLUMN_SIMPLESHORT = "\"csimple_short_value\" numeric(5,0)";
    private static final String COLUMN_INT = "\"cint_value\" numeric(10,0)";
    private static final String COLUMN_SIMPLEINT = "\"csimple_int_value\" numeric(10,0)";
    private static final String COLUMN_LONG = "\"clong_value\" numeric(19,0)";
    private static final String COLUMN_SIMPLELONG = "\"csimple_long_value\" numeric(19,0)";
    private static final String COLUMN_FLOAT = "\"cfloat_value\" float";
    private static final String COLUMN_SIMPLEFLOAT = "\"csimple_float_value\" float";
    private static final String COLUMN_DOUBLE = "\"cdouble_value\" double precision";
    private static final String COLUMN_SIMPLEDOUBLE = "\"csimple_double_value\" double precision";
    private static final String COLUMN_DATE = "\"cdate_value\" numeric(19,0)";

    private static boolean impl_containSqlStringThisPart(String sSql, String sPart) throws Exception {
        return StringUtils.contains((CharSequence)sSql, (CharSequence)sPart);
    }

    private static boolean impl_containTableName(String sSql) throws Exception {
        return AnsiSqlGeneratorTest.impl_containSqlStringThisPart(sSql, TABLE_NAME);
    }

    private static boolean impl_containSqlStringAllTestEntityColumnsAndTypes(String sSql) throws Exception {
        if (!AnsiSqlGeneratorTest.impl_containSqlStringThisPart(sSql, COLUMN_CHAR)) {
            return false;
        }
        if (!AnsiSqlGeneratorTest.impl_containSqlStringThisPart(sSql, COLUMN_STRING)) {
            return false;
        }
        if (!AnsiSqlGeneratorTest.impl_containSqlStringThisPart(sSql, COLUMN_BOOLEAN)) {
            return false;
        }
        if (!AnsiSqlGeneratorTest.impl_containSqlStringThisPart(sSql, COLUMN_SIMPLEBOOLEAN)) {
            return false;
        }
        if (!AnsiSqlGeneratorTest.impl_containSqlStringThisPart(sSql, COLUMN_BYTE)) {
            return false;
        }
        if (!AnsiSqlGeneratorTest.impl_containSqlStringThisPart(sSql, COLUMN_SIMPLEBYTE)) {
            return false;
        }
        if (!AnsiSqlGeneratorTest.impl_containSqlStringThisPart(sSql, COLUMN_SHORT)) {
            return false;
        }
        if (!AnsiSqlGeneratorTest.impl_containSqlStringThisPart(sSql, COLUMN_SIMPLESHORT)) {
            return false;
        }
        if (!AnsiSqlGeneratorTest.impl_containSqlStringThisPart(sSql, COLUMN_INT)) {
            return false;
        }
        if (!AnsiSqlGeneratorTest.impl_containSqlStringThisPart(sSql, COLUMN_SIMPLEINT)) {
            return false;
        }
        if (!AnsiSqlGeneratorTest.impl_containSqlStringThisPart(sSql, COLUMN_LONG)) {
            return false;
        }
        if (!AnsiSqlGeneratorTest.impl_containSqlStringThisPart(sSql, COLUMN_SIMPLELONG)) {
            return false;
        }
        if (!AnsiSqlGeneratorTest.impl_containSqlStringThisPart(sSql, COLUMN_FLOAT)) {
            return false;
        }
        if (!AnsiSqlGeneratorTest.impl_containSqlStringThisPart(sSql, COLUMN_SIMPLEFLOAT)) {
            return false;
        }
        if (!AnsiSqlGeneratorTest.impl_containSqlStringThisPart(sSql, COLUMN_DOUBLE)) {
            return false;
        }
        if (!AnsiSqlGeneratorTest.impl_containSqlStringThisPart(sSql, COLUMN_SIMPLEDOUBLE)) {
            return false;
        }
        return AnsiSqlGeneratorTest.impl_containSqlStringThisPart(sSql, COLUMN_DATE);
    }

    private static boolean impl_containSqlStringAllTestEntityColumns(String sSql) throws Exception {
        if (!AnsiSqlGeneratorTest.impl_containSqlStringThisPart(sSql, "char_value")) {
            return false;
        }
        if (!AnsiSqlGeneratorTest.impl_containSqlStringThisPart(sSql, "string_value")) {
            return false;
        }
        if (!AnsiSqlGeneratorTest.impl_containSqlStringThisPart(sSql, "boolean_value")) {
            return false;
        }
        if (!AnsiSqlGeneratorTest.impl_containSqlStringThisPart(sSql, "simple_boolean_value")) {
            return false;
        }
        if (!AnsiSqlGeneratorTest.impl_containSqlStringThisPart(sSql, "byte_value")) {
            return false;
        }
        if (!AnsiSqlGeneratorTest.impl_containSqlStringThisPart(sSql, "simple_byte_value")) {
            return false;
        }
        if (!AnsiSqlGeneratorTest.impl_containSqlStringThisPart(sSql, "short_value")) {
            return false;
        }
        if (!AnsiSqlGeneratorTest.impl_containSqlStringThisPart(sSql, "simple_short_value")) {
            return false;
        }
        if (!AnsiSqlGeneratorTest.impl_containSqlStringThisPart(sSql, "int_value")) {
            return false;
        }
        if (!AnsiSqlGeneratorTest.impl_containSqlStringThisPart(sSql, "simple_int_value")) {
            return false;
        }
        if (!AnsiSqlGeneratorTest.impl_containSqlStringThisPart(sSql, "long_value")) {
            return false;
        }
        if (!AnsiSqlGeneratorTest.impl_containSqlStringThisPart(sSql, "simple_long_value")) {
            return false;
        }
        if (!AnsiSqlGeneratorTest.impl_containSqlStringThisPart(sSql, "float_value")) {
            return false;
        }
        if (!AnsiSqlGeneratorTest.impl_containSqlStringThisPart(sSql, "simple_float_value")) {
            return false;
        }
        if (!AnsiSqlGeneratorTest.impl_containSqlStringThisPart(sSql, "double_value")) {
            return false;
        }
        if (!AnsiSqlGeneratorTest.impl_containSqlStringThisPart(sSql, "simple_double_value")) {
            return false;
        }
        return AnsiSqlGeneratorTest.impl_containSqlStringThisPart(sSql, "date_value");
    }

    @Test
    public void testSqlStatementCreation() throws Exception {
        TestEntity aEntity = new TestEntity();
        AnsiSqlGenerator aSqlGenerator = new AnsiSqlGenerator();
        Row aMeta = this.impl_generateMetaRowForEntity(aEntity);
        String sSql = null;
        sSql = aSqlGenerator.createSql(ISqlGenerator.EStatementType.E_CREATE_TABLE, aMeta, null);
        AssertEx.assertTrue((String)"testSqlStatementCreation [01]", (boolean)sSql.startsWith("create table "));
        AssertEx.assertTrue((String)"testSqlStatementCreation [02]", (boolean)AnsiSqlGeneratorTest.impl_containTableName(sSql));
        AssertEx.assertTrue((String)"testSqlStatementCreation [03]", (boolean)AnsiSqlGeneratorTest.impl_containSqlStringAllTestEntityColumnsAndTypes(sSql));
        sSql = aSqlGenerator.createSql(ISqlGenerator.EStatementType.E_DELETE, aMeta, null);
        AssertEx.assertTrue((String)"testSqlStatementCreation [04]", (boolean)sSql.startsWith("delete from "));
        AssertEx.assertTrue((String)"testSqlStatementCreation [05]", (boolean)AnsiSqlGeneratorTest.impl_containTableName(sSql));
        sSql = aSqlGenerator.createSql(ISqlGenerator.EStatementType.E_DELETE_ALL, aMeta, null);
        AssertEx.assertTrue((String)"testSqlStatementCreation [06]", (boolean)sSql.startsWith("delete from "));
        AssertEx.assertTrue((String)"testSqlStatementCreation [07]", (boolean)AnsiSqlGeneratorTest.impl_containTableName(sSql));
        sSql = aSqlGenerator.createSql(ISqlGenerator.EStatementType.E_INSERT, aMeta, null);
        AssertEx.assertTrue((String)"testSqlStatementCreation [08]", (boolean)sSql.startsWith("insert into "));
        AssertEx.assertTrue((String)"testSqlStatementCreation [09]", (boolean)AnsiSqlGeneratorTest.impl_containTableName(sSql));
        sSql = aSqlGenerator.createSql(ISqlGenerator.EStatementType.E_QUERY_BY_ID, aMeta, null);
        AssertEx.assertTrue((String)"testSqlStatementCreation [10]", (boolean)sSql.startsWith("select * from "));
        AssertEx.assertTrue((String)"testSqlStatementCreation [11]", (boolean)AnsiSqlGeneratorTest.impl_containTableName(sSql));
        sSql = aSqlGenerator.createSql(ISqlGenerator.EStatementType.E_UPDATE, aMeta, null);
        AssertEx.assertTrue((String)"testSqlStatementCreation [12]", (boolean)sSql.startsWith("update "));
        AssertEx.assertTrue((String)"testSqlStatementCreation [13]", (boolean)AnsiSqlGeneratorTest.impl_containTableName(sSql));
        AssertEx.assertTrue((String)"testSqlStatementCreation [14]", (boolean)AnsiSqlGeneratorTest.impl_containSqlStringAllTestEntityColumns(sSql));
    }

    @Test
    public void testCreatingTableNames() throws Exception {
        TestEntity aEntity = new TestEntity();
        String sEntitySchema = TEST_DB_SCHEMA;
        Row aMeta = this.impl_generateMetaRowForEntity(aEntity);
        String sEntityTable = "t" + aMeta.getTable();
        AnsiSqlGenerator aSqlGenerator = new AnsiSqlGenerator();
        String sExpectedTableName = null;
        String sGeneratedTableName = null;
        sExpectedTableName = "\"" + sEntitySchema + "\"" + "." + "\"" + sEntityTable + "\"";
        sGeneratedTableName = (String)ObjectManipulation.callPrivateMethod((Object)aSqlGenerator, (String)"impl_nameTable", (Object[])new Object[]{aMeta});
        AssertEx.assertEquals((String)"testCreatingTableNames [01] check with valid schema", (Object)sExpectedTableName, (Object)sGeneratedTableName);
        aMeta.getEntityMetaInfo().setSchema(null);
        sExpectedTableName = "\"" + sEntityTable + "\"";
        sGeneratedTableName = (String)ObjectManipulation.callPrivateMethod((Object)aSqlGenerator, (String)"impl_nameTable", (Object[])new Object[]{aMeta});
        AssertEx.assertEquals((String)"testCreatingTableNames [02] check when schema NULL", (Object)sExpectedTableName, (Object)sGeneratedTableName);
        aMeta.getEntityMetaInfo().setSchema("");
        sExpectedTableName = "\"" + sEntityTable + "\"";
        sGeneratedTableName = (String)ObjectManipulation.callPrivateMethod((Object)aSqlGenerator, (String)"impl_nameTable", (Object[])new Object[]{aMeta});
        AssertEx.assertEquals((String)"testCreatingTableNames [03] check when schema empty", (Object)sExpectedTableName, (Object)sGeneratedTableName);
    }

    private Row impl_generateMetaRowForEntity(EntityBase aEntity) throws Exception {
        EntityMetaInfo aMeta = new EntityMetaInfo();
        aMeta.setClassName(aEntity.getClass().getName());
        aMeta.setSchema(TEST_DB_SCHEMA);
        EntityClassParserAnnotations.parse((EntityMetaInfo)aMeta);
        Row aRow = EntityHelper.createRowFromEntity((EntityMetaInfo)aMeta, (EntityBase)aEntity);
        return aRow;
    }
}

