/*
 * Decompiled with CFR 0.152.
 */
package test.net.as_development.asdk.db_service.impl.simpledb;

import net.as_development.asdk.db_service.impl.simpledb.NumberStringUtils;
import org.junit.Assert;
import org.junit.Test;

public class NumberStringUtilsTest {
    private static final int RANGE = 10;

    @Test
    public void testBytes() throws Exception {
        this.impl_testBytes((byte)-128);
        this.impl_testBytes((byte)-5);
        this.impl_testBytes((byte)117);
    }

    @Test
    public void testShorts() throws Exception {
        this.impl_testShorts((short)Short.MIN_VALUE);
        this.impl_testShorts((short)-5);
        this.impl_testShorts((short)32757);
    }

    @Test
    public void testInts() throws Exception {
        this.impl_testInts(Integer.MIN_VALUE);
        this.impl_testInts(-5);
        this.impl_testInts(0x7FFFFFF5);
    }

    @Test
    public void testLongs() throws Exception {
        this.impl_testLongs(Long.MIN_VALUE);
        this.impl_testLongs(-5L);
        this.impl_testLongs(0x7FFFFFFFFFFFFFF5L);
    }

    private void impl_testBytes(byte nStart) throws Exception {
        String sLast = null;
        String sNow = null;
        byte nValue = nStart;
        for (int i = 0; i < 10; ++i) {
            sNow = NumberStringUtils.mapToString((Number)nValue);
            this.impl_log("[" + nValue + "] -> '" + sNow + "'");
            if (sLast != null) {
                Assert.assertTrue((String)("[" + nValue + "] : '" + sLast + "' < '" + sNow + "'"), (sLast.compareTo(sNow) < 0 ? 1 : 0) != 0);
            }
            sLast = sNow;
            byte nCheck = (Byte)NumberStringUtils.mapToNumber((String)sNow, Byte.class);
            this.impl_log("[" + nCheck + "] <- '" + sNow + "'");
            Assert.assertEquals((String)(nCheck + " vs " + nValue), (long)nCheck, (long)nValue);
            nValue = (byte)(nValue + 1);
        }
    }

    private void impl_testShorts(short nStart) throws Exception {
        String sLast = null;
        String sNow = null;
        short nValue = nStart;
        for (int i = 0; i < 10; ++i) {
            sNow = NumberStringUtils.mapToString((Number)nValue);
            this.impl_log("[" + nValue + "] -> '" + sNow + "'");
            if (sLast != null) {
                Assert.assertTrue((String)("[" + nValue + "] : '" + sLast + "' < '" + sNow + "'"), (sLast.compareTo(sNow) < 0 ? 1 : 0) != 0);
            }
            sLast = sNow;
            short nCheck = (Short)NumberStringUtils.mapToNumber((String)sNow, Short.class);
            this.impl_log("[" + nCheck + "] <- '" + sNow + "'");
            Assert.assertEquals((String)(nCheck + " vs " + nValue), (long)nCheck, (long)nValue);
            nValue = (short)(nValue + 1);
        }
    }

    private void impl_testInts(int nStart) throws Exception {
        String sLast = null;
        String sNow = null;
        int nValue = nStart;
        for (int i = 0; i < 10; ++i) {
            sNow = NumberStringUtils.mapToString((Number)nValue);
            this.impl_log("[" + nValue + "] -> '" + sNow + "'");
            if (sLast != null) {
                Assert.assertTrue((String)("[" + nValue + "] : '" + sLast + "' < '" + sNow + "'"), (sLast.compareTo(sNow) < 0 ? 1 : 0) != 0);
            }
            sLast = sNow;
            int nCheck = (Integer)NumberStringUtils.mapToNumber((String)sNow, Integer.class);
            this.impl_log("[" + nCheck + "] <- '" + sNow + "'");
            Assert.assertEquals((String)(nCheck + " vs " + nValue), (long)nCheck, (long)nValue);
            ++nValue;
        }
    }

    private void impl_testLongs(long nStart) throws Exception {
        String sLast = null;
        String sNow = null;
        long nValue = nStart;
        for (int i = 0; i < 10; ++i) {
            sNow = NumberStringUtils.mapToString((Number)nValue);
            this.impl_log("[" + nValue + "] -> '" + sNow + "'");
            if (sLast != null) {
                Assert.assertTrue((String)("[" + nValue + "] : '" + sLast + "' < '" + sNow + "'"), (sLast.compareTo(sNow) < 0 ? 1 : 0) != 0);
            }
            sLast = sNow;
            long nCheck = (Long)NumberStringUtils.mapToNumber((String)sNow, Long.class);
            this.impl_log("[" + nCheck + "] <- '" + sNow + "'");
            Assert.assertEquals((String)(nCheck + " vs " + nValue), (long)nCheck, (long)nValue);
            ++nValue;
        }
    }

    private void impl_log(String sMsg) throws Exception {
        System.out.println(sMsg);
    }
}

