/*
 * Decompiled with CFR 0.152.
 */
package test.net.as_development.asdk.db_service.impl.server;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import net.as_development.asdk.api.db.IEntity;
import net.as_development.asdk.api.db.IPersistenceUnit;
import net.as_development.asdk.api.sql.ISqlServer;
import net.as_development.asdk.db_service.impl.DB;
import net.as_development.asdk.db_service.impl.PersistenceUnit;
import net.as_development.asdk.db_service.impl.server.DBBackup;
import net.as_development.asdk.db_service.impl.sql.SqlProvider;
import net.as_development.asdk.sql.server.impl.EmbeddedDerbyServer;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import test.net.as_development.asdk.db_service.test.entities.TestEntity;

public class DBBackupTest {
    private ISqlServer m_iSourceDBServer = null;
    private ISqlServer m_iTargetDBServer = null;
    private IPersistenceUnit m_iSourceConnection = null;
    private IPersistenceUnit m_iTargetConnection = null;
    private IPersistenceUnit m_iEntityPU = null;
    private TestEntity[] m_lTestEntities = null;

    @Before
    public void setUp() throws Exception {
        File aTemp = FileUtils.getTempDirectory();
        File aSourceDBPath = new File(aTemp, "junit_source_db");
        File aTargetDBPath = new File(aTemp, "junit_target_db");
        EmbeddedDerbyServer iSource = new EmbeddedDerbyServer();
        EmbeddedDerbyServer iTarget = new EmbeddedDerbyServer();
        iSource.enablePersistentData(false);
        iTarget.enablePersistentData(false);
        iSource.setWorkDir(aSourceDBPath.getAbsolutePath());
        iTarget.setWorkDir(aTargetDBPath.getAbsolutePath());
        this.m_iSourceConnection = DBBackupTest.impl_getConnectionData((ISqlServer)iSource);
        this.m_iTargetConnection = DBBackupTest.impl_getConnectionData((ISqlServer)iTarget);
        PersistenceUnit iEntityPU = new PersistenceUnit();
        iEntityPU.setName("test_entity");
        iEntityPU.setProvider(SqlProvider.class.getName());
        iEntityPU.addEntity(TestEntity.class.getName());
        this.m_iEntityPU = iEntityPU;
        iSource.start();
        iTarget.start();
        this.m_iSourceDBServer = iSource;
        this.m_iTargetDBServer = iTarget;
        this.impl_cleanDB(this.m_iSourceConnection);
        this.impl_cleanDB(this.m_iTargetConnection);
        this.impl_createTestDB(this.m_iSourceConnection);
    }

    @After
    public void tearDown() throws Exception {
        if (this.m_iSourceDBServer != null) {
            this.m_iSourceDBServer.stop();
        }
        if (this.m_iTargetDBServer != null) {
            this.m_iTargetDBServer.stop();
        }
        this.m_iSourceDBServer = null;
        this.m_iTargetDBServer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBackup() throws Exception {
        Date aLastBackup = new Date(0L);
        DBBackup aBackup = new DBBackup();
        aBackup.setSourceConnection(this.m_iSourceConnection);
        aBackup.setTargetConnection(this.m_iTargetConnection);
        aBackup.setEntities(new IPersistenceUnit[]{this.m_iEntityPU});
        aBackup.setLastBackupDate(aLastBackup);
        System.out.println("backup 1");
        aBackup.run();
        aLastBackup = aBackup.getNewBackupDate();
        aBackup.setLastBackupDate(aLastBackup);
        TestEntity[] lCheck = this.impl_readDB(this.m_iTargetConnection);
        Assert.assertEquals((String)"testBackup [01] not all entities seems to be handled by backup 1", (long)this.m_lTestEntities.length, (long)lCheck.length);
        this.impl_cleanDB(this.m_iTargetConnection);
        DBBackupTest dBBackupTest = this;
        synchronized (dBBackupTest) {
            this.wait(1000L);
        }
        this.impl_updateTestDB(this.m_iSourceConnection, this.m_lTestEntities[5]);
        System.out.println("backup 2");
        aBackup.run();
        lCheck = this.impl_readDB(this.m_iTargetConnection);
        Assert.assertEquals((String)"testBackup [02] unexpected count of backup items", (long)1L, (long)lCheck.length);
    }

    private void impl_cleanDB(IPersistenceUnit iConnection) throws Exception {
        PersistenceUnit aPU = new PersistenceUnit(this.m_iEntityPU);
        aPU.merge(iConnection);
        DB iDB = new DB();
        iDB.setPersistenceUnit((IPersistenceUnit)aPU);
        iDB.removeEntitySchema(TestEntity.class);
        iDB.createEntitySchema(TestEntity.class);
    }

    private void impl_createTestDB(IPersistenceUnit iConnection) throws Exception {
        int c = 10;
        int i = 0;
        this.m_lTestEntities = new TestEntity[c];
        for (i = 0; i < c; ++i) {
            this.m_lTestEntities[i] = new TestEntity();
        }
        this.impl_updateTestDB(iConnection, this.m_lTestEntities);
    }

    private void impl_updateTestDB(IPersistenceUnit iConnection, TestEntity ... lEntities) throws Exception {
        PersistenceUnit aPU = new PersistenceUnit(this.m_iEntityPU);
        aPU.merge(iConnection);
        DB iDB = new DB();
        iDB.setPersistenceUnit((IPersistenceUnit)aPU);
        iDB.storeEntities((IEntity[])lEntities);
    }

    private TestEntity[] impl_readDB(IPersistenceUnit iConnection) throws Exception {
        PersistenceUnit aPU = new PersistenceUnit(this.m_iEntityPU);
        aPU.merge(iConnection);
        DB iDB = new DB();
        iDB.setPersistenceUnit((IPersistenceUnit)aPU);
        ArrayList lResults = new ArrayList();
        iDB.getAllEntitiesOfType(TestEntity.class, null, lResults);
        int c = lResults.size();
        int i = 0;
        TestEntity[] lEntities = new TestEntity[c];
        for (i = 0; i < c; ++i) {
            lEntities[i] = (TestEntity)((Object)lResults.get(i));
        }
        return lEntities;
    }

    private static IPersistenceUnit impl_getConnectionData(ISqlServer iServer) throws Exception {
        PersistenceUnit iPU = new PersistenceUnit();
        iPU.setProperty("jdbc.driver", iServer.getDriverClass());
        iPU.setProperty("jdbc.connection.url", iServer.getConnectionUrl());
        iPU.setProperty("db.user", iServer.getUser());
        iPU.setProperty("db.password", iServer.getPassword());
        return iPU;
    }
}

