/*
 * Decompiled with CFR 0.152.
 */
package test.net.as_development.asdk.db_service.impl.backend.mongodb;

import net.as_development.asdk.db_service.impl.NextToken;
import org.junit.Assert;
import org.junit.Test;

public class NextTokenTest {
    @Test
    public void testDefaults() throws Exception {
        NextToken aToken = new NextToken();
        Assert.assertEquals((String)"testDefaults [01] check offset", (long)0L, (long)aToken.getOffset());
        Assert.assertEquals((String)"testDefaults [02] check pagesize", (long)NextToken.DEFAULT_PAGESIZE, (long)aToken.getPageSize());
    }

    @Test
    public void testParsingEmptyToken() throws Exception {
        NextToken aToken = new NextToken();
        aToken.parse(null);
        Assert.assertEquals((String)"testParsingEmptyToken [01] parsing an null token (check offset)", (long)0L, (long)aToken.getOffset());
        Assert.assertEquals((String)"testParsingEmptyToken [02] parsing an null token (check pagesize)", (long)NextToken.DEFAULT_PAGESIZE, (long)aToken.getPageSize());
        aToken.parse("");
        Assert.assertEquals((String)"testParsingEmptyToken [03] parsing an empty token (check offset)", (long)0L, (long)aToken.getOffset());
        Assert.assertEquals((String)"testParsingEmptyToken [04] parsing an empty token (check pagesize)", (long)NextToken.DEFAULT_PAGESIZE, (long)aToken.getPageSize());
    }

    @Test
    public void testParsingValidToken() throws Exception {
        int nOffset = 0;
        int nPageSize = 0;
        NextToken aToken = new NextToken();
        nOffset = 197;
        nPageSize = 1584;
        aToken.parse("offset=" + nOffset + ";" + "pagesize" + "=" + nPageSize);
        Assert.assertEquals((String)"testParsingValidToken [01] check offset", (long)nOffset, (long)aToken.getOffset());
        Assert.assertEquals((String)"testParsingValidToken [02] check pagesize", (long)nPageSize, (long)aToken.getPageSize());
        nOffset = 18;
        nPageSize = 7777;
        aToken.parse("pagesize=" + nPageSize + ";" + "offset" + "=" + nOffset);
        Assert.assertEquals((String)"testParsingValidToken [03] check offset", (long)nOffset, (long)aToken.getOffset());
        Assert.assertEquals((String)"testParsingValidToken [04] check pagesize", (long)nPageSize, (long)aToken.getPageSize());
        nOffset = 796;
        aToken.parse("offset=" + nOffset);
        Assert.assertEquals((String)"testParsingValidToken [05] check offset", (long)nOffset, (long)aToken.getOffset());
        Assert.assertEquals((String)"testParsingValidToken [06] check pagesize", (long)NextToken.DEFAULT_PAGESIZE, (long)aToken.getPageSize());
        nPageSize = 1234;
        aToken.parse("pagesize=" + nPageSize);
        Assert.assertEquals((String)"testParsingValidToken [07] check offset", (long)0L, (long)aToken.getOffset());
        Assert.assertEquals((String)"testParsingValidToken [08] check pagesize", (long)nPageSize, (long)aToken.getPageSize());
    }

    @Test
    public void testAssemblingToken() throws Exception {
        int nOffset = 19;
        int nPageSize = 1357;
        NextToken aToken = new NextToken();
        aToken.setOffset(nOffset);
        aToken.setPageSize(nPageSize);
        String sToken = aToken.asString();
        String sExpectedToken = "offset=" + nOffset + ";" + "pagesize" + "=" + nPageSize;
        Assert.assertEquals((String)"testAssemblingToken [01]", (Object)sExpectedToken, (Object)sToken);
    }
}

