/*
 * Decompiled with CFR 0.152.
 */
package test.net.as_development.asdk.db_service.impl.backend.creator;

import java.util.Vector;
import junit.framework.Assert;
import net.as_development.asdk.api.db.IDB;
import net.as_development.asdk.api.db.IDBPool;
import net.as_development.asdk.api.db.IDBSchema;
import net.as_development.asdk.api.service.env.IServiceEnv;
import net.as_development.asdk.db_service.impl.PersistenceUnit;
import net.as_development.asdk.db_service.impl.backend.creator.DBCreator;
import net.as_development.asdk.service.env.ServiceEnv;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import test.net.as_development.asdk.db_service.test.entities.TestEntity;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={PersistenceUnit.class, ServiceEnv.class})
public class DBCreatorTest {
    private IDBPool m_iDBPoolMock = null;
    private IDBSchema m_iDBMock = null;
    private PersistenceUnit m_aPersistenceUnitMock = null;

    @Before
    public void setUp() throws Exception {
        String sPersistenceUnit = "test_persistence_unit";
        Vector<String> lEntities = new Vector<String>(10);
        lEntities.add(TestEntity.class.getName());
        this.m_aPersistenceUnitMock = (PersistenceUnit)Mockito.mock(PersistenceUnit.class);
        Mockito.when((Object)this.m_aPersistenceUnitMock.getName()).thenReturn((Object)sPersistenceUnit);
        Mockito.when((Object)this.m_aPersistenceUnitMock.getEntities()).thenReturn(lEntities);
        Vector<String> lPersistenceUnitNames = new Vector<String>(10);
        lPersistenceUnitNames.add(sPersistenceUnit);
        PowerMockito.mockStatic(PersistenceUnit.class, (Class[])new Class[0]);
        Mockito.when((Object)PersistenceUnit.listUnits()).thenReturn(lPersistenceUnitNames);
        Mockito.when((Object)PersistenceUnit.loadUnit((String)sPersistenceUnit)).thenReturn((Object)this.m_aPersistenceUnitMock);
        IServiceEnv iServiceManager = (IServiceEnv)Mockito.mock(IServiceEnv.class);
        this.m_iDBPoolMock = (IDBPool)Mockito.mock(IDBPool.class);
        this.m_iDBMock = (IDBSchema)Mockito.mock(IDBSchema.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{IDB.class}));
        PowerMockito.mockStatic(IServiceEnv.class, (Class[])new Class[0]);
        Mockito.when((Object)ServiceEnv.get()).thenReturn((Object)iServiceManager);
        Mockito.when((Object)iServiceManager.getService(IDBPool.class)).thenReturn((Object)this.m_iDBPoolMock);
        Mockito.when((Object)this.m_iDBPoolMock.getDbForPersistenceUnit(sPersistenceUnit)).thenReturn((Object)((IDB)this.m_iDBMock));
    }

    @After
    public void tearDown() throws Exception {
    }

    @Ignore
    public void testCredentialHandling() throws Exception {
        String sUser = "a_user";
        String sPassword = "a_password";
        ArgumentCaptor aUserCaptor = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor aPasswordCaptor = ArgumentCaptor.forClass(String.class);
        DBCreator aCreator = new DBCreator();
        aCreator.setAdminCredentials(sUser, sPassword);
        aCreator.doOperation(DBCreator.EOperation.E_CREATE);
        ((PersistenceUnit)Mockito.verify((Object)this.m_aPersistenceUnitMock, (VerificationMode)Mockito.times((int)1))).setUser((String)aUserCaptor.capture());
        Assert.assertEquals((String)"testCredentialHandling [01] check if user was set on persistence unit.", (String)sUser, (String)((String)aUserCaptor.getValue()));
        ((PersistenceUnit)Mockito.verify((Object)this.m_aPersistenceUnitMock, (VerificationMode)Mockito.times((int)1))).setPassword((String)aPasswordCaptor.capture());
        Assert.assertEquals((String)"testCredentialHandling [02] check if password was set on persistence unit.", (String)sUser, (String)((String)aUserCaptor.getValue()));
    }

    @Ignore
    public void testSchemaCreation() throws Exception {
        ArgumentCaptor aCaptor = ArgumentCaptor.forClass(Class.class);
        DBCreator aCreator = new DBCreator();
        aCreator.setAdminCredentials("root", "xxx");
        aCreator.doOperation(DBCreator.EOperation.E_CREATE);
        ((IDBSchema)Mockito.verify((Object)this.m_iDBMock)).createEntitySchema((Class)aCaptor.capture());
        Assert.assertEquals((String)"testSchemaCreation [01] check if schema will be created for right entity", TestEntity.class, (Object)aCaptor.getValue());
    }
}

