/*
 * Decompiled with CFR 0.152.
 */
package test.net.as_development.asdk.db_service.impl;

import net.as_development.asdk.db_service.impl.EntityMetaInfoProvider;
import net.as_development.asdk.db_service.impl.PersistenceUnit;
import org.junit.Assert;
import org.junit.Test;
import test.net.as_development.asdk.db_service.test.entities.TestEntity;

public class EntityMetaInfoProviderTest {
    @Test
    public void testIdentifierLengthConstraint() throws Exception {
        EntityMetaInfoProvider aProvider;
        PersistenceUnit aPersistenceUnit = new PersistenceUnit();
        aPersistenceUnit.setName("test_persistence_unit");
        aPersistenceUnit.addEntity(TestEntity.class.getName());
        aPersistenceUnit.setProperty("constraint.max_string_length", "100000");
        try {
            aProvider = new EntityMetaInfoProvider();
            aProvider.setPersistenceUnit(aPersistenceUnit);
            aPersistenceUnit.setProperty("constraint.max_identifier_length", "1000");
            aProvider.retrieveMetaInfo();
        }
        catch (Throwable ex) {
            Assert.fail((String)("testIdentifierLengthConstraint [01] no exception expected if constrain max_identifier_length is not violated. But got '" + ex.getMessage() + "'."));
        }
        try {
            aProvider = new EntityMetaInfoProvider();
            aProvider.setPersistenceUnit(aPersistenceUnit);
            aPersistenceUnit.setProperty("constraint.max_identifier_length", "10");
            aProvider.retrieveMetaInfo();
            Assert.fail((String)"testIdentifierLengthConstraint [02] miss exception if constrain max_identifier_length is violated.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMaxStringLengthConstraint() throws Exception {
        EntityMetaInfoProvider aProvider;
        PersistenceUnit aPersistenceUnit = new PersistenceUnit();
        aPersistenceUnit.setName("test_persistence_unit");
        aPersistenceUnit.addEntity(TestEntity.class.getName());
        aPersistenceUnit.setProperty("constraint.max_identifier_length", "100000");
        try {
            aProvider = new EntityMetaInfoProvider();
            aProvider.setPersistenceUnit(aPersistenceUnit);
            aPersistenceUnit.setProperty("constraint.max_string_length", "4000");
            aProvider.retrieveMetaInfo();
        }
        catch (Throwable ex) {
            Assert.fail((String)("testMaxStringLengthConstraint [01] no exception expected if constrain max_string_length is not violated. But got '" + ex.getMessage() + "'."));
        }
        try {
            aProvider = new EntityMetaInfoProvider();
            aProvider.setPersistenceUnit(aPersistenceUnit);
            aPersistenceUnit.setProperty("constraint.max_string_length", "5");
            aProvider.retrieveMetaInfo();
            Assert.fail((String)"testMaxStringLengthConstraint [02] miss exception if constrain max_string_length is violated.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

