/*
 * Decompiled with CFR 0.152.
 */
package test.net.as_development.asdk.db_service.impl;

import net.as_development.asdk.db_service.EntityBase;
import net.as_development.asdk.tools.test.AssertEx;
import org.junit.Test;

public class EntityBaseTest {
    @Test
    public void testSetExpire() throws Exception {
        EntityBase aEntity = new EntityBase();
        AssertEx.assertNull((String)"testSetExpire [01] default for 'expire' has to be 'null'.", (Object)aEntity.Expire);
        long nTestExpire = 10L;
        long nMaxDiff = 50L;
        long nExpectedExpire = System.currentTimeMillis() + nTestExpire * 1000L;
        aEntity.setExpireInSeconds(nTestExpire);
        long nActualExpire = aEntity.Expire;
        long nDiff = nActualExpire - nExpectedExpire;
        AssertEx.assertTrue((String)("testSetExpire [02] calculated expire time (in seconds) does not fit the range we expected here. Diff between expected and calculated time was " + nDiff + " ms."), (nDiff <= nMaxDiff ? 1 : 0) != 0);
        nTestExpire = 10L;
        nMaxDiff = 50L;
        nExpectedExpire = System.currentTimeMillis() + nTestExpire * 1000L * 60L;
        aEntity.setExpireInMinutes(nTestExpire);
        nActualExpire = aEntity.Expire;
        nDiff = nActualExpire - nExpectedExpire;
        AssertEx.assertTrue((String)("testSetExpire [03] calculated expire time (in minutes) does not fit the range we expected here. Diff between expected and calculated time was " + nDiff + " ms."), (nDiff <= nMaxDiff ? 1 : 0) != 0);
        aEntity.setExpireInSeconds(1L);
        AssertEx.assertNotNull((String)"testSetExpire [04] expire set on calling setExpireInSeconds(1).", (Object)aEntity.Expire);
        aEntity.setExpireInSeconds(0L);
        AssertEx.assertNull((String)"testSetExpire [05] expire not rested on calling setExpireInSeconds(0).", (Object)aEntity.Expire);
        aEntity.setExpireInMinutes(1L);
        AssertEx.assertNotNull((String)"testSetExpire [06] expire set on calling setExpireInMinutes(1).", (Object)aEntity.Expire);
        aEntity.setExpireInMinutes(0L);
        AssertEx.assertNull((String)"testSetExpire [07] expire not rested on calling setExpireInMinutes(0).", (Object)aEntity.Expire);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIsExpired() throws Exception {
        long nOffset = 50L;
        long nExpireInSeconds = 1L;
        long nWaitForNonExpired = nExpireInSeconds * 1000L - nOffset;
        long nWaitForExpired = nExpireInSeconds * 1000L + nOffset;
        EntityBase aEntity = new EntityBase();
        aEntity.setExpireInSeconds(nExpireInSeconds);
        EntityBaseTest entityBaseTest = this;
        synchronized (entityBaseTest) {
            this.wait(nWaitForNonExpired);
        }
        AssertEx.assertFalse((String)"testIsExpired [01] expect to get FALSE if isExpired() is called to early.", (boolean)aEntity.isExpired());
        aEntity.setExpireInSeconds(nExpireInSeconds);
        entityBaseTest = this;
        synchronized (entityBaseTest) {
            this.wait(nWaitForExpired);
        }
        AssertEx.assertTrue((String)"testIsExpired [01] expect to get TRUE if isExpired() is called to late.", (boolean)aEntity.isExpired());
    }
}

