/*
 * Decompiled with CFR 0.152.
 */
package test.net.as_development.asdk.db_service.impl;

import net.as_development.asdk.api.db.EQueryPartBinding;
import net.as_development.asdk.api.db.EQueryPartOperation;
import net.as_development.asdk.db_service.impl.AttributeListMetaInfo;
import net.as_development.asdk.db_service.impl.AttributeMetaInfo;
import net.as_development.asdk.db_service.impl.DBQueryTemplate;
import net.as_development.asdk.db_service.impl.EntityMetaInfo;
import net.as_development.asdk.tools.test.AssertEx;
import org.junit.Test;
import org.mockito.Mockito;

public class DBQueryTest {
    @Test
    public void testIllegalArguments() throws Exception {
        DBQueryTemplate aQuery = null;
        String sValidAttribute = "ValidAttribute";
        String sInvalidAttribute = "";
        Integer aValidMinRange = 0;
        Object aInvalidMinRange = null;
        Integer aValidMaxRange = 100;
        Object aInvalidMaxRange = null;
        String sValidLike = "some_value*?";
        String sInvalidLike = "";
        EntityMetaInfo aEntityMeta = (EntityMetaInfo)Mockito.mock(EntityMetaInfo.class);
        aQuery = new DBQueryTemplate("", aEntityMeta);
        AssertEx.assertThrowsException((String)"testIllegalArguments [01] test invalid attribute at match  ()", IllegalArgumentException.class, (Object)aQuery, (String)"match", (Object[])new Object[]{sInvalidAttribute, null});
        AssertEx.assertThrowsException((String)"testIllegalArguments [02] test invalid attribute at like   ()", IllegalArgumentException.class, (Object)aQuery, (String)"like", (Object[])new Object[]{sInvalidAttribute, sValidLike});
        AssertEx.assertThrowsException((String)"testIllegalArguments [03] test invalid attribute at between()", IllegalArgumentException.class, (Object)aQuery, (String)"between", (Object[])new Object[]{sInvalidAttribute, aValidMinRange, aValidMaxRange});
        aQuery = new DBQueryTemplate("", aEntityMeta);
        AssertEx.assertThrowsException((String)"testIllegalArguments [04] test invalid value at like()", IllegalArgumentException.class, (Object)aQuery, (String)"like", (Object[])new Object[]{sValidAttribute, sInvalidLike});
        aQuery = new DBQueryTemplate("", aEntityMeta);
        AssertEx.assertThrowsException((String)"testIllegalArguments [05] test invalid min range at between()", IllegalArgumentException.class, (Object)aQuery, (String)"between", (Object[])new Object[]{sValidAttribute, aInvalidMinRange, aValidMaxRange});
        AssertEx.assertThrowsException((String)"testIllegalArguments [06] test invalid max range at between()", IllegalArgumentException.class, (Object)aQuery, (String)"between", (Object[])new Object[]{sValidAttribute, aValidMinRange, aInvalidMaxRange});
    }

    @Test
    public void testAttributeCheckAfterCompile() throws Exception {
        DBQueryTemplate aQuery = null;
        String sQueryId = "my_query";
        String sQueryAttribute = "query_attribute";
        String sUnknownAttribute = "unknown_attribute";
        String sColumnForAttribute = "column_of_query_attribute";
        Boolean aMatchValue = Boolean.TRUE;
        String sLikeValue = "wildcards?*";
        Integer aMinRange = 0;
        Integer aMaxRange = 100;
        EntityMetaInfo aEntityMeta = (EntityMetaInfo)Mockito.mock(EntityMetaInfo.class);
        AttributeListMetaInfo aAttributeListMeta = (AttributeListMetaInfo)Mockito.mock(AttributeListMetaInfo.class);
        AttributeMetaInfo aAttributeMeta = (AttributeMetaInfo)Mockito.mock(AttributeMetaInfo.class);
        Mockito.when((Object)aEntityMeta.getAttributes()).thenReturn((Object)aAttributeListMeta);
        Mockito.when((Object)aAttributeListMeta.getForAttributeName(sQueryAttribute)).thenReturn((Object)aAttributeMeta);
        Mockito.when((Object)aAttributeMeta.getColumnName()).thenReturn((Object)sColumnForAttribute);
        aQuery = new DBQueryTemplate(sQueryId, aEntityMeta);
        aQuery.setQueryPart(0, EQueryPartBinding.E_AND, EQueryPartOperation.E_MATCH, sQueryAttribute);
        aQuery = new DBQueryTemplate("", aEntityMeta);
        aQuery.setQueryPart(0, EQueryPartBinding.E_AND, EQueryPartOperation.E_MATCH, sQueryAttribute);
        aQuery.compile();
        AssertEx.assertThrowsException((String)"testAttributeCheckAfterCompile [01] for match ()", RuntimeException.class, (Object)aQuery, (String)"match", (Object[])new Object[]{sUnknownAttribute, aMatchValue});
        AssertEx.assertThrowsException((String)"testAttributeCheckAfterCompile [02] for like ()", RuntimeException.class, (Object)aQuery, (String)"like", (Object[])new Object[]{sUnknownAttribute, sLikeValue});
        AssertEx.assertThrowsException((String)"testAttributeCheckAfterCompile [03] for between ()", RuntimeException.class, (Object)aQuery, (String)"between", (Object[])new Object[]{sUnknownAttribute, aMinRange, aMaxRange});
    }

    @Test
    public void testIfBackendGetRightInfos() throws Exception {
    }
}

