/*
 * Decompiled with CFR 0.152.
 */
package test.net.as_development.asdk.db_service;

import net.as_development.asdk.api.db.IDB;
import net.as_development.asdk.api.db.IDBPool;
import net.as_development.asdk.api.service.env.IServiceEnv;
import net.as_development.asdk.db_service.DBItemBase;
import net.as_development.asdk.tools.test.AssertEx;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class DBItemBaseTest {
    @Before
    public void setUp() throws Exception {
        IServiceEnv iSmgr = (IServiceEnv)Mockito.mock(IServiceEnv.class);
        IDBPool iPool = (IDBPool)Mockito.mock(IDBPool.class);
        IDB iDB = (IDB)Mockito.mock(IDB.class);
        Mockito.when((Object)iPool.getDbForPersistenceUnit(Mockito.anyString())).thenReturn((Object)iDB);
        Mockito.when((Object)iSmgr.getService(IDBPool.class)).thenReturn((Object)iPool);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testPUNaming() throws Exception {
        String sName = null;
        Class<DBItemBase> aTestClass = DBItemBase.class;
        String sExpectedName = aTestClass.getName();
        sName = DBItemBase.namePersistenceUnit(aTestClass);
        AssertEx.assertEquals((String)"testPUNaming [01]", (Object)sExpectedName, (Object)sName);
    }

    @Test
    public void testQueryNaming() throws Exception {
        String sName = null;
        Class<DBItemBase> aTestClass = DBItemBase.class;
        String sQuery = "my-query";
        String sExpectedName = aTestClass.getName() + ":" + sQuery;
        sName = DBItemBase.nameQuery(aTestClass, (String)sQuery);
        AssertEx.assertEquals((String)"testQueryNaming [01]", (Object)sExpectedName, (Object)sName);
    }

    private class DBItemBaseTestClass
    extends DBItemBase {
        public int m_nCalls = 0;
        public String m_sPersistenceUnit = null;

        public DBItemBaseTestClass(String sPersistenceUnit) {
            this.m_sPersistenceUnit = sPersistenceUnit;
        }

        protected String getPersistenceUnitName() throws Exception {
            ++this.m_nCalls;
            return this.m_sPersistenceUnit;
        }
    }
}

