/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jef4j.util;

import java.io.Serializable;
import java.util.Arrays;
import net.arnx.jef4j.util.ByteUtils;
import net.arnx.jef4j.util.Record;

public class CharRecord
implements Record,
Serializable {
    private static final long serialVersionUID = 1L;
    private char pattern;
    private char[] array;

    public CharRecord() {
    }

    public CharRecord(char pattern, char[] array) {
        this.set(pattern, array);
    }

    public void set(char pattern, char[] array) {
        this.pattern = pattern;
        this.array = array;
    }

    @Override
    public boolean exists(int pos) {
        if (pos == 65535) {
            return true;
        }
        return (this.pattern & (char)(1 << 15 - pos)) != 0;
    }

    @Override
    public long get(int pos) {
        if (pos == 65535) {
            return this.array[pos];
        }
        return this.array[Integer.bitCount(this.pattern >> 16 - pos)];
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.pattern;
        result = 31 * result + Arrays.hashCode(this.array);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CharRecord other = (CharRecord)obj;
        if (this.pattern != other.pattern) {
            return false;
        }
        return Arrays.equals(this.array, other.array);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            if (this.exists(i)) {
                sb.append(ByteUtils.hex(this.get(i), 2));
                continue;
            }
            sb.append("  ");
        }
        return sb.toString();
    }
}

