/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jef4j.util;

import java.io.Serializable;

public class LongObjMap<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long[] keys;
    private T[] values;
    private int size;
    private int mask;
    private float fillFactor;
    private int threshold;
    private T zeroValue;

    public LongObjMap() {
        this(16, 0.75f);
    }

    public LongObjMap(int size) {
        this(size, 0.75f);
    }

    public LongObjMap(int size, float loadFactor) {
        if (size <= 0) {
            throw new IllegalArgumentException("size must be positive!");
        }
        if (loadFactor <= 0.0f || loadFactor >= 1.0f) {
            throw new IllegalArgumentException("loadFactor must be in (0, 1)");
        }
        int capacity = LongObjMap.calcCapacity(size, loadFactor);
        this.keys = new long[capacity];
        this.values = LongObjMap.newArray(this.keys.length);
        this.mask = capacity - 1;
        this.fillFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
    }

    public T put(long key, T value) {
        if (key == 0L) {
            T oldValue = this.zeroValue;
            this.zeroValue = value;
            return oldValue;
        }
        int ptr = this.hash(key);
        while (true) {
            long k;
            if ((k = this.keys[ptr]) == 0L) {
                this.keys[ptr] = key;
                this.values[ptr] = value;
                if (this.size >= this.threshold) {
                    this.rehash(this.keys.length * 2);
                } else {
                    ++this.size;
                }
                return null;
            }
            if (k == key) {
                T ret = this.values[ptr];
                this.values[ptr] = value;
                return ret;
            }
            ptr = ptr + 1 & this.mask;
        }
    }

    public T get(long key) {
        if (key == 0L) {
            return this.zeroValue;
        }
        int pos = this.hash(key);
        long k;
        while ((k = this.keys[pos]) != 0L) {
            if (k == key) {
                return this.values[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return null;
    }

    public int size() {
        return this.size + (this.zeroValue != null ? 1 : 0);
    }

    private static int calcCapacity(int size, float f) {
        long x = (long)Math.ceil((float)size / f);
        if (x != 0L) {
            --x;
            x |= x >> 1;
            x |= x >> 2;
            x |= x >> 4;
            x |= x >> 8;
            x |= x >> 16;
            x |= x >> 32;
            if (++x > 0x40000000L) {
                throw new IllegalArgumentException("Too large (" + size + " expected elements with load factor " + f + ")");
            }
        }
        return Math.max(2, (int)x);
    }

    private int hash(long x) {
        int h = (int)(x * -1640531527L);
        return (h ^ h >> 16) & this.mask;
    }

    private void rehash(int newCapacity) {
        this.threshold = (int)((float)newCapacity * this.fillFactor);
        this.mask = newCapacity - 1;
        long[] oldKeys = this.keys;
        T[] oldValues = this.values;
        this.keys = new long[newCapacity];
        this.values = LongObjMap.newArray(newCapacity);
        this.size = 0;
        for (int i = 0; i < oldKeys.length; ++i) {
            long oldKey = oldKeys[i];
            if (oldKey == 0L) continue;
            this.put(oldKey, oldValues[i]);
        }
    }

    private static <T> T[] newArray(int size) {
        return new Object[size];
    }
}

