/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jef4j;

import java.io.ObjectInputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import net.arnx.jef4j.FujitsuCharsetType;
import net.arnx.jef4j.util.LongObjMap;
import net.arnx.jef4j.util.Record;

class FujitsuCharsetEncoder
extends CharsetEncoder {
    private static final byte[] ASCII_MAP;
    private static final byte[] EBCDIC_MAP;
    private static final byte[] EBCDIK_MAP;
    private static final LongObjMap<Record> JEF_MAP;
    private static final ByteBuffer DUMMY;
    private final FujitsuCharsetType type;
    private final byte[] map;
    private boolean kshifted = false;
    private StringBuilder backup;

    public FujitsuCharsetEncoder(Charset cs, FujitsuCharsetType type) {
        super(cs, FujitsuCharsetEncoder.getAverageBytesPerChar(type), FujitsuCharsetEncoder.getMaxBytesPerChar(type), FujitsuCharsetEncoder.getReplacementChar(type));
        this.type = type;
        switch (type) {
            case ASCII: 
            case JEF_ASCII: 
            case JEF_HD_ASCII: {
                this.map = ASCII_MAP;
                break;
            }
            case EBCDIC: 
            case JEF_EBCDIC: 
            case JEF_HD_EBCDIC: {
                this.map = EBCDIC_MAP;
                break;
            }
            case EBCDIK: 
            case JEF_EBCDIK: 
            case JEF_HD_EBCDIK: {
                this.map = EBCDIK_MAP;
                break;
            }
            default: {
                this.map = null;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
        block12: {
            int mark;
            block11: {
                char c;
                block13: {
                    if (this.backup == null) break block12;
                    if (out.remaining() < 2) {
                        return CoderResult.OVERFLOW;
                    }
                    if (!in.hasRemaining()) {
                        return CoderResult.UNDERFLOW;
                    }
                    mark = in.position();
                    c = in.get();
                    if (!Character.isHighSurrogate(c)) break block13;
                    if (!in.hasRemaining()) {
                        if (!this.isEndOfInput()) {
                            in.position(mark);
                            return CoderResult.UNDERFLOW;
                        }
                        this.backup.append(c);
                        break block11;
                    } else {
                        char c2 = in.get();
                        if (Character.isLowSurrogate(c2)) {
                            this.backup.append(c);
                            this.backup.append(c2);
                            break block11;
                        } else {
                            if (!this.isEndOfInput()) {
                                in.position(mark);
                                return CoderResult.malformedForLength(1);
                            }
                            this.backup.append(c);
                            this.backup.append(c2);
                        }
                    }
                    break block11;
                }
                this.backup.append(c);
            }
            CharBuffer in2 = CharBuffer.wrap(this.backup);
            this.backup = null;
            CoderResult cr = this.encodeLoop(in2, out, true);
            if (cr.isMalformed()) {
                int delta = in.position() - mark;
                in.position(mark);
                return CoderResult.malformedForLength(delta);
            }
            if (cr.isUnmappable()) {
                int delta = in.position() - mark;
                in.position(mark);
                return CoderResult.unmappableForLength(delta);
            }
            if (cr.isOverflow()) {
                in.position(mark);
                return CoderResult.OVERFLOW;
            }
        }
        return this.encodeLoop(in, out, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoderResult encodeLoop(CharBuffer in, ByteBuffer out, boolean restored) {
        int mark = in.position();
        try {
            CoderResult cr;
            block59: {
                while (in.hasRemaining()) {
                    long key;
                    char c = in.get();
                    if (c >= '\ufffe') {
                        CoderResult coderResult = CoderResult.unmappableForLength(1);
                        return coderResult;
                    }
                    if (c <= '\u007f' || this.map == EBCDIC_MAP && (c == '\u00a3' || c == '\u00a6' || c == '\u00ac') || this.map == EBCDIK_MAP && (c == '\u00a3' || c == '\u00ac' || c >= '\uff61' && c <= '\uff9f')) {
                        byte value;
                        if (this.map == null) {
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                        if (this.map == EBCDIK_MAP && c >= '\uff61' && c <= '\uff9f') {
                            c = (char)(c - 65377 + 192);
                        }
                        if ((value = this.map[c]) == -1) {
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                        if (this.kshifted) {
                            if (!out.hasRemaining()) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            out.put((byte)41);
                            this.kshifted = false;
                        }
                        if (!out.hasRemaining()) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        out.put(value);
                        ++mark;
                        continue;
                    }
                    if (!this.type.handleJEF()) {
                        CoderResult coderResult = CoderResult.unmappableForLength(1);
                        return coderResult;
                    }
                    if (c >= '\ue000' && c <= '\uec1d') {
                        out.put((byte)(128 + (c - 57344) / 94 & 0xFF));
                        out.put((byte)(161 + (c - 57344) % 94 & 0xFF));
                        ++mark;
                        continue;
                    }
                    int progress = 1;
                    if (Character.isSurrogate(c)) {
                        CoderResult coderResult;
                        if (!Character.isHighSurrogate(c)) {
                            coderResult = CoderResult.malformedForLength(1);
                            return coderResult;
                        }
                        if (!in.hasRemaining()) {
                            coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        char c2 = in.get();
                        if (!Character.isLowSurrogate(c2)) {
                            CoderResult coderResult2 = CoderResult.malformedForLength(2);
                            return coderResult2;
                        }
                        ++progress;
                        key = Character.toCodePoint(c, c2);
                    } else {
                        key = c;
                    }
                    Record record = JEF_MAP.get(key & 0xFFFFFFFFFFFFFFF0L);
                    if (record == null || !record.exists((int)(key & 0xFL))) {
                        CoderResult coderResult = CoderResult.unmappableForLength(1);
                        return coderResult;
                    }
                    if (this.type.handleShift() && !this.kshifted) {
                        if (!out.hasRemaining()) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        out.put((byte)40);
                        this.kshifted = true;
                    }
                    if (out.remaining() < 2) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    int mc = -1;
                    cr = null;
                    if (this.type.handleHanyoDenshi()) {
                        if (!in.hasRemaining()) {
                            if (!restored) {
                                this.backup = new StringBuilder().appendCodePoint((int)key);
                                mark += progress;
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                        } else {
                            int mark2 = in.position();
                            char c3 = in.get();
                            if (c3 == '\u3099') {
                                long key2 = (long)c3 << 20 | key;
                                Record record2 = JEF_MAP.get(key2 & 0xFFFFFFFFF0L);
                                if (record2 != null && record2.exists((int)(key2 & 0xFL))) {
                                    mc = (char)record2.get((int)(key2 & 0xFL));
                                    ++progress;
                                } else {
                                    in.position(mark2);
                                }
                            } else if (c3 == '\udb40') {
                                if (!in.hasRemaining()) {
                                    if (this.isEndOfInput()) {
                                        cr = CoderResult.malformedForLength(1);
                                    } else {
                                        if (!restored) {
                                            this.backup = new StringBuilder().appendCodePoint((int)key);
                                            mark += progress;
                                            CoderResult key2 = CoderResult.UNDERFLOW;
                                            return key2;
                                        }
                                        in.position(mark2);
                                    }
                                } else {
                                    char c4 = in.get();
                                    if (Character.isLowSurrogate(c4)) {
                                        long key2 = (long)Character.toCodePoint(c3, c4) << 20 | key;
                                        Record record2 = JEF_MAP.get(key2 & 0xFFFFFFFFF0L);
                                        if (record2 != null && record2.exists((int)(key2 & 0xFL))) {
                                            mc = (char)record2.get((int)(key2 & 0xFL));
                                            progress += 2;
                                        } else {
                                            cr = CoderResult.unmappableForLength(2);
                                        }
                                    } else {
                                        cr = CoderResult.malformedForLength(2);
                                    }
                                }
                            }
                        }
                    }
                    if (mc == -1) {
                        mc = (char)record.get((int)(key & 0xFL));
                    }
                    out.put((byte)(mc >> 8 & 0xFF));
                    out.put((byte)(mc & 0xFF));
                    mark += progress;
                    if (cr == null) {
                        continue;
                    }
                    break block59;
                }
                return CoderResult.UNDERFLOW;
            }
            CoderResult coderResult = cr;
            return coderResult;
        }
        finally {
            in.position(mark);
        }
    }

    @Override
    protected CoderResult implFlush(ByteBuffer out) {
        if (out == DUMMY) {
            return CoderResult.OVERFLOW;
        }
        if (this.backup != null) {
            CharBuffer in = CharBuffer.wrap(this.backup);
            this.backup = null;
            CoderResult cr = this.encodeLoop(in, out, true);
            if (cr.isError()) {
                throw new IllegalStateException();
            }
            if (cr.isOverflow()) {
                return CoderResult.OVERFLOW;
            }
        }
        if (this.type.handleShift() && this.kshifted) {
            if (!out.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            out.put((byte)40);
            this.kshifted = false;
        }
        return CoderResult.UNDERFLOW;
    }

    @Override
    protected void implReset() {
        this.kshifted = false;
        this.backup = null;
    }

    private boolean isEndOfInput() {
        try {
            return this.flush(DUMMY).isOverflow();
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    private static float getAverageBytesPerChar(FujitsuCharsetType type) {
        switch (type) {
            case ASCII: 
            case EBCDIC: 
            case EBCDIK: {
                return 1.0f;
            }
        }
        return 2.0f;
    }

    private static float getMaxBytesPerChar(FujitsuCharsetType type) {
        switch (type) {
            case ASCII: 
            case EBCDIC: 
            case EBCDIK: {
                return 1.0f;
            }
            case JEF: {
                return 2.0f;
            }
        }
        return 4.0f;
    }

    private static byte[] getReplacementChar(FujitsuCharsetType type) {
        switch (type) {
            case ASCII: 
            case EBCDIC: 
            case EBCDIK: {
                return new byte[]{64};
            }
        }
        return new byte[]{64, 64};
    }

    static {
        DUMMY = ByteBuffer.allocate(0);
        try (ObjectInputStream in = new ObjectInputStream(FujitsuCharsetEncoder.class.getResourceAsStream("FujitsuEncodeMap.dat"));){
            ASCII_MAP = (byte[])in.readObject();
            EBCDIC_MAP = (byte[])in.readObject();
            EBCDIK_MAP = (byte[])in.readObject();
            JEF_MAP = (LongObjMap)in.readObject();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

