/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.server.support;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.apexes.wsonrpc.core.WebSocketSession;
import net.apexes.wsonrpc.core.WsonrpcConfig;
import net.apexes.wsonrpc.core.WsonrpcConfigBuilder;
import net.apexes.wsonrpc.server.PathAcceptor;
import net.apexes.wsonrpc.server.PathAcceptors;
import net.apexes.wsonrpc.server.WsonrpcServer;
import net.apexes.wsonrpc.server.WsonrpcServerBase;
import org.java_websocket.WebSocket;
import org.java_websocket.WebSocketAdapter;
import org.java_websocket.WebSocketImpl;
import org.java_websocket.WebSocketListener;
import org.java_websocket.WebSocketServerFactory;
import org.java_websocket.drafts.Draft;
import org.java_websocket.exceptions.InvalidDataException;
import org.java_websocket.framing.Framedata;
import org.java_websocket.framing.PingFrame;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.handshake.ServerHandshakeBuilder;
import org.java_websocket.server.DefaultWebSocketServerFactory;
import org.java_websocket.server.WebSocketServer;

public class JavaWebsocketWsonrpcServer {
    protected final WebSocketServer websocketServer;
    protected final WsonrpcServerBase serverBase;
    private final WebSocketServerFactory wsf = new DefaultWebSocketServerFactory(){

        public WebSocketImpl createWebSocket(WebSocketAdapter a, Draft d) {
            return new SessionWebSocketImpl((WebSocketListener)a, d);
        }

        public WebSocketImpl createWebSocket(WebSocketAdapter a, List<Draft> d) {
            return new SessionWebSocketImpl((WebSocketListener)a, d);
        }
    };
    private volatile AtomicBoolean isclose = new AtomicBoolean(false);

    public JavaWebsocketWsonrpcServer(int port) {
        this(port, PathAcceptors.rootPath());
    }

    public JavaWebsocketWsonrpcServer(int port, WsonrpcConfig config) {
        this(port, PathAcceptors.rootPath(), config);
    }

    public JavaWebsocketWsonrpcServer(int port, PathAcceptor pathAcceptor) {
        this(port, pathAcceptor, WsonrpcConfigBuilder.defaultConfig());
    }

    public JavaWebsocketWsonrpcServer(int port, PathAcceptor pathAcceptor, WsonrpcConfig config) {
        this.websocketServer = new WebSocketServerAdapter(new InetSocketAddress(port), pathAcceptor, this);
        this.websocketServer.setWebSocketFactory(this.wsf);
        this.serverBase = new WsonrpcServerBase(config);
    }

    public WsonrpcServer getWsonrpcServer() {
        return this.serverBase;
    }

    public void start() {
        this.isclose.set(false);
        try {
            this.websocketServer.start();
        }
        finally {
            this.isclose.set(true);
        }
    }

    public void stop() throws IOException, InterruptedException {
        this.isclose.set(true);
        this.websocketServer.stop();
    }

    public boolean isRunning() {
        return !this.isclose.get();
    }

    private static String sessionId(WebSocket websocket) {
        if (websocket == null) {
            return null;
        }
        String id = websocket instanceof SessionWebSocketImpl ? ((SessionWebSocketImpl)websocket).getId() : websocket.getRemoteSocketAddress().toString();
        return id;
    }

    private static class JavaWebSocketSessionAdapter
    implements WebSocketSession {
        private static PingFrame PING_FRAME = new PingFrame();
        private final WebSocket websocket;

        JavaWebSocketSessionAdapter(WebSocket websocket) {
            this.websocket = websocket;
        }

        public String getId() {
            return JavaWebsocketWsonrpcServer.sessionId(this.websocket);
        }

        public boolean isOpen() {
            return this.websocket.isOpen();
        }

        public void sendBinary(byte[] bytes) throws IOException {
            this.websocket.send(bytes);
        }

        public void ping() throws IOException {
            this.websocket.sendFrame((Framedata)PING_FRAME);
        }

        public void close() throws IOException {
            this.websocket.close();
        }
    }

    private static class WebSocketServerAdapter
    extends WebSocketServer {
        private final JavaWebsocketWsonrpcServer server;
        private final PathAcceptor pathAcceptor;

        public WebSocketServerAdapter(InetSocketAddress address, PathAcceptor pathAcceptor, JavaWebsocketWsonrpcServer server) {
            super(address);
            this.pathAcceptor = pathAcceptor;
            this.server = server;
        }

        public ServerHandshakeBuilder onWebsocketHandshakeReceivedAsServer(WebSocket websockt, Draft draft, ClientHandshake request) throws InvalidDataException {
            if (this.pathAcceptor == null || this.pathAcceptor.accept(request.getResourceDescriptor())) {
                return super.onWebsocketHandshakeReceivedAsServer(websockt, draft, request);
            }
            throw new InvalidDataException(1015, request.getResourceDescriptor());
        }

        public void onOpen(WebSocket websockt, ClientHandshake handshake) {
            this.server.serverBase.onOpen(new JavaWebSocketSessionAdapter(websockt));
        }

        public void onStart() {
        }

        public void onClose(WebSocket websockt, int code, String reason, boolean remote) {
            this.server.serverBase.onClose(JavaWebsocketWsonrpcServer.sessionId(websockt));
        }

        public void onMessage(WebSocket websockt, String message) {
            this.server.serverBase.onMessage(JavaWebsocketWsonrpcServer.sessionId(websockt), ByteBuffer.wrap(message.getBytes()));
        }

        public void onMessage(WebSocket websockt, ByteBuffer message) {
            this.server.serverBase.onMessage(JavaWebsocketWsonrpcServer.sessionId(websockt), message);
        }

        public void onError(WebSocket websockt, Exception ex) {
            if (this.server.isRunning()) {
                this.server.serverBase.onError(JavaWebsocketWsonrpcServer.sessionId(websockt), ex);
            }
        }
    }

    private static class SessionWebSocketImpl
    extends WebSocketImpl {
        private final String id = UUID.randomUUID().toString();

        public SessionWebSocketImpl(WebSocketListener listener, Draft draft) {
            super(listener, draft);
        }

        public SessionWebSocketImpl(WebSocketListener listener, List<Draft> drafts) {
            super(listener, drafts);
        }

        String getId() {
            return this.id;
        }
    }
}

