/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.server;

import java.nio.ByteBuffer;
import net.apexes.wsonrpc.core.ServiceRegistry;
import net.apexes.wsonrpc.core.WebSocketSession;
import net.apexes.wsonrpc.core.WsonrpcConfig;
import net.apexes.wsonrpc.server.RemoteWsonrpcEndpoint;
import net.apexes.wsonrpc.server.WsonrpcRemotes;
import net.apexes.wsonrpc.server.WsonrpcRequestInterceptor;
import net.apexes.wsonrpc.server.WsonrpcServer;
import net.apexes.wsonrpc.server.WsonrpcServerEngine;
import net.apexes.wsonrpc.server.WsonrpcServerListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsonrpcServerBase
implements WsonrpcServer {
    private static final Logger LOG = LoggerFactory.getLogger(WsonrpcServerBase.class);
    private final WsonrpcServerEngine wsonrpcEngine;
    private WsonrpcServerListener serverListener;

    public WsonrpcServerBase(WsonrpcConfig config) {
        this.wsonrpcEngine = new WsonrpcServerEngine(config);
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        return this.wsonrpcEngine.getServiceRegistry();
    }

    @Override
    public void setServerListener(WsonrpcServerListener listener) {
        this.serverListener = listener;
    }

    @Override
    public void setWsonrpcRequestInterceptor(WsonrpcRequestInterceptor interceptor) {
        this.wsonrpcEngine.setWsonrpcRequestInterceptor(interceptor);
    }

    public void onOpen(WebSocketSession session) {
        WsonrpcRemotes.addRemote(session, new RemoteWsonrpcEndpoint(session, this.wsonrpcEngine));
        this.fireOpen(session);
    }

    public void onClose(String sessionId) {
        WsonrpcRemotes.removeRemote(sessionId);
        this.fireClose(sessionId);
    }

    public void onMessage(String sessionId, ByteBuffer buffer) {
        WebSocketSession session = WsonrpcRemotes.getSession(sessionId);
        byte[] bytes = buffer.array();
        try {
            this.fireMessage(sessionId, bytes);
            this.wsonrpcEngine.handle(session, bytes);
        }
        catch (Exception ex) {
            this.onError(session.getId(), ex);
        }
    }

    public void onError(String sessionId, Throwable error) {
        this.wsonrpcEngine.onError(sessionId, error);
    }

    private void fireOpen(WebSocketSession session) {
        LOG.debug("onOpen : {}", (Object)session.getId());
        if (this.serverListener != null) {
            this.serverListener.onOpen(session);
        }
    }

    private void fireClose(String sessionId) {
        LOG.debug("onClose : {}", (Object)sessionId);
        if (this.serverListener != null) {
            this.serverListener.onClose(sessionId);
        }
    }

    private void fireMessage(String sessionId, byte[] bytes) {
        LOG.debug("onMessage : {}", (Object)sessionId);
        if (this.serverListener != null) {
            this.serverListener.onMessage(sessionId, bytes);
        }
    }
}

