/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.server;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.apexes.wsonrpc.core.WebSocketSession;
import net.apexes.wsonrpc.core.WsonrpcRemote;
import net.apexes.wsonrpc.server.RemoteWsonrpcEndpoint;
import net.apexes.wsonrpc.server.WsonrpcSessions;

public final class WsonrpcRemotes {
    private static final Map<String, RemoteWsonrpcEndpoint> remotes = new ConcurrentHashMap<String, RemoteWsonrpcEndpoint>();

    private WsonrpcRemotes() {
    }

    static void addRemote(WebSocketSession session, RemoteWsonrpcEndpoint endpoint) {
        remotes.put(session.getId(), endpoint);
    }

    static void removeRemote(String sessionId) {
        remotes.remove(sessionId);
    }

    static WebSocketSession getSession(String sessionId) {
        if (sessionId == null) {
            return null;
        }
        RemoteWsonrpcEndpoint endpoint = remotes.get(sessionId);
        if (endpoint == null) {
            return null;
        }
        return endpoint.getSession();
    }

    public static WsonrpcRemote getRemote(String sessionId) {
        if (sessionId == null) {
            return null;
        }
        return (WsonrpcRemote)remotes.get(sessionId);
    }

    public static Collection<? extends WsonrpcRemote> getRemotes() {
        return remotes.values();
    }

    public static WsonrpcRemote getRemote() {
        WebSocketSession session = WsonrpcSessions.get();
        if (session != null) {
            return WsonrpcRemotes.getRemote(session.getId());
        }
        return null;
    }
}

