/*
 * Copyright (c) 2018. , apexes.net. All rights reserved.
 *
 *         http://www.apexes.net
 *
 */
package net.apexes.wsonrpc.server;

import net.apexes.wsonrpc.core.JsonException;
import net.apexes.wsonrpc.core.WebSocketSession;
import net.apexes.wsonrpc.core.WsonrpcException;
import net.apexes.wsonrpc.json.JsonRpcError;

import java.lang.reflect.Method;
import java.lang.reflect.Type;

/**
 * Wsonrpc请求拦截器
 *
 * @author <a href="mailto:hedyn@foxmail.com">HeDYn</a>
 */
public interface WsonrpcRequestInterceptor {

    /**
     * 可以调用{@link Context#executeReply()}方法触发执行并回复；
     * 或者调用{@link Context#replyValue(Object)}进行回复
     *
     * @param context
     */
    void handle(Context context);

    /**
     *
     * @author <a href="mailto:hedyn@foxmail.com">HeDYn</a>
     */
    interface Context {

        /**
         * 返回当前会话
         * @return
         */
        WebSocketSession getSession();

        /**
         * 返回请求方法
         * @return
         */
        String getServiceMethod();

        /**
         * 返回参数
         * @return
         */
        Object getParams();

        /**
         * 返回适配指定类型的参数数组
         * @param types
         * @return
         */
        Object[] getParams(Type[] types);

        /**
         * 返回参数的json
         * @return
         * @throws JsonException
         */
        String getParamsAsJson() throws JsonException;

        /**
         * 触发执行并回复
         */
        void executeReply();

        /**
         * 回复
         * @param result
         */
        void replyValue(Object result);

        /**
         *
         * @param t
         */
        void replyThrowable(Throwable t);

        /**
         *
         * @param error
         */
        void replyError(JsonRpcError error);
    }

}
