/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.server;

import java.lang.reflect.Type;
import net.apexes.wsonrpc.core.JsonException;
import net.apexes.wsonrpc.core.WebSocketSession;
import net.apexes.wsonrpc.core.WsonrpcConfig;
import net.apexes.wsonrpc.core.WsonrpcEngine;
import net.apexes.wsonrpc.core.WsonrpcLogger;
import net.apexes.wsonrpc.json.JsonRpcError;
import net.apexes.wsonrpc.json.JsonRpcRequest;
import net.apexes.wsonrpc.json.JsonRpcResponse;
import net.apexes.wsonrpc.server.WsonrpcRequestInterceptor;
import net.apexes.wsonrpc.server.WsonrpcSessions;

class WsonrpcServerEngine
extends WsonrpcEngine {
    private WsonrpcRequestInterceptor wsonrpcRequestInterceptor;

    WsonrpcServerEngine(WsonrpcConfig config) {
        super(config);
    }

    void onError(String sessionId, Throwable error) {
        WsonrpcLogger logger = this.getConfig().getWsonrpcLogger();
        if (logger != null) {
            logger.onError(sessionId, error);
        }
    }

    void setWsonrpcRequestInterceptor(WsonrpcRequestInterceptor interceptor) {
        this.wsonrpcRequestInterceptor = interceptor;
    }

    protected void handleRequest(WebSocketSession session, JsonRpcRequest request) {
        WsonrpcRequestInterceptor interceptor = this.wsonrpcRequestInterceptor;
        if (interceptor != null && request != null) {
            interceptor.handle(new ContextImpl(session, request));
        } else {
            this.execReply(session, request);
        }
    }

    private void execReply(WebSocketSession session, JsonRpcRequest request) {
        super.handleRequest(session, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JsonRpcResponse execute(WebSocketSession session, JsonRpcRequest request) {
        if (WsonrpcSessions.get() == session) {
            return super.execute(session, request);
        }
        WsonrpcSessions.begin(session);
        try {
            JsonRpcResponse jsonRpcResponse = super.execute(session, request);
            return jsonRpcResponse;
        }
        finally {
            WsonrpcSessions.end();
        }
    }

    private class ContextImpl
    implements WsonrpcRequestInterceptor.Context {
        private final WebSocketSession session;
        private final JsonRpcRequest request;

        private ContextImpl(WebSocketSession session, JsonRpcRequest request) {
            this.session = session;
            this.request = request;
        }

        @Override
        public WebSocketSession getSession() {
            return this.session;
        }

        @Override
        public String getServiceMethod() {
            return this.request.getMethod();
        }

        @Override
        public Object getParams() {
            return this.request.getParams();
        }

        @Override
        public Object[] getParams(Type[] types) {
            return this.request.getParams(types);
        }

        @Override
        public String getParamsAsJson() throws JsonException {
            return this.request.getParamsAsJson();
        }

        @Override
        public void executeReply() {
            WsonrpcServerEngine.this.execReply(this.session, this.request);
        }

        @Override
        public void replyValue(Object result) {
            if (result != null) {
                JsonRpcResponse resp = WsonrpcServerEngine.this.toResponse(this.request.getId(), result);
                WsonrpcServerEngine.this.transmit(this.session, resp);
            }
        }

        @Override
        public void replyThrowable(Throwable t) {
            this.replyError(JsonRpcError.internalError((Throwable)t));
        }

        @Override
        public void replyError(JsonRpcError error) {
            WsonrpcServerEngine.this.transmit(this.session, WsonrpcServerEngine.this.getJsonImplementor().createResponse(this.request.getId(), error));
        }
    }
}

