/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.virtual;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.apartium.cocoabeans.CollectionHelpers;
import net.apartium.cocoabeans.commands.Command;
import net.apartium.cocoabeans.commands.CommandInfo;
import net.apartium.cocoabeans.commands.CommandNode;
import net.apartium.cocoabeans.commands.SubCommand;
import net.apartium.cocoabeans.commands.virtual.VirtualCommandDefinition;
import net.apartium.cocoabeans.commands.virtual.VirtualCommandVariant;
import net.apartium.cocoabeans.commands.virtual.VirtualMetadata;
import net.apartium.cocoabeans.reflect.ClassUtils;
import net.apartium.cocoabeans.reflect.MethodUtils;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="0.0.39")
@ApiStatus.Experimental
public class VirtualCommandFactory {
    private final List<BiConsumer<AnnotatedElement, Map<String, Object>>> mappers = new ArrayList<BiConsumer<AnnotatedElement, Map<String, Object>>>();

    public void addMetadataMapper(BiConsumer<AnnotatedElement, Map<String, Object>> mapper) {
        this.mappers.add(mapper);
    }

    public VirtualCommandDefinition create(CommandNode ... nodes) {
        if (nodes.length == 0) {
            return null;
        }
        Class<?> baseClass = nodes[0].getClass();
        Command baseCommand = baseClass.getAnnotation(Command.class);
        if (baseCommand == null) {
            return null;
        }
        for (int i = 1; i < nodes.length; ++i) {
            Class<?> clazz = nodes[i].getClass();
            Command command = clazz.getAnnotation(Command.class);
            if (command == null) {
                throw new IllegalArgumentException("Command " + clazz.getName() + " is not annotated with @Command");
            }
            if (!baseCommand.value().equals(command.value())) {
                throw new IllegalArgumentException("Command name aren't same \nExpected: " + baseCommand.value() + "\nActual: " + command.value());
            }
            if (CollectionHelpers.equalsArray((Object[])baseCommand.aliases(), (Object[])command.aliases())) continue;
            throw new IllegalArgumentException("Command alias aren't same \nExpected: " + Arrays.toString(baseCommand.aliases()) + "\nActual: " + Arrays.toString(command.aliases()));
        }
        List<Class<?>> classes = Arrays.stream(nodes).map(Object::getClass).collect(Collectors.toList());
        return new VirtualCommandDefinition(baseCommand.value(), Set.of(baseCommand.aliases()), CommandInfo.createFromAnnotations(classes.stream().map(Class::getAnnotations).toList()), this.getVariants(classes), this.getMetadata(classes));
    }

    protected void metaDataMap(AnnotatedElement element, Map<String, Object> metadata) {
        for (BiConsumer<AnnotatedElement, Map<String, Object>> mapper : this.mappers) {
            mapper.accept(element, metadata);
        }
        for (VirtualMetadata virtualMetadata : (VirtualMetadata[])element.getAnnotationsByType(VirtualMetadata.class)) {
            metadata.put(virtualMetadata.key(), virtualMetadata.value());
        }
    }

    protected Map<String, Object> getMetadata(Collection<Class<?>> classes) {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        for (Class<?> clazz : classes) {
            for (Class targetClass : ClassUtils.getSuperClassAndInterfaces(clazz)) {
                this.metaDataMap(targetClass, metadata);
            }
        }
        return metadata;
    }

    protected Map<String, Object> getMetadata(Method method) {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        for (Method targetMethod : MethodUtils.getMethodsFromSuperClassAndInterface((Method)method)) {
            this.metaDataMap(targetMethod, metadata);
        }
        this.metaDataMap(method, metadata);
        return metadata;
    }

    protected Set<VirtualCommandVariant> getVariants(Collection<Class<?>> classes) {
        HashSet<VirtualCommandVariant> variants = new HashSet<VirtualCommandVariant>();
        for (Class<?> clazz : classes) {
            for (Method method : MethodUtils.getAllMethods(clazz)) {
                this.getVariants(method, variants);
            }
        }
        return variants;
    }

    protected void getVariants(Method method, Set<VirtualCommandVariant> variants) {
        SubCommand[] subCommands = (SubCommand[])method.getAnnotationsByType(SubCommand.class);
        ArrayList<Annotation[]> annotations = new ArrayList<Annotation[]>();
        annotations.add(method.getAnnotations());
        for (Method targetMethod : MethodUtils.getMethodsFromSuperClassAndInterface((Method)method)) {
            annotations.add(targetMethod.getAnnotations());
        }
        Map<String, Object> metadata = null;
        CommandInfo info = null;
        for (SubCommand subCommand : subCommands) {
            variants.add(new VirtualCommandVariant(info == null ? CommandInfo.createFromAnnotations(annotations) : info, subCommand.value(), subCommand.ignoreCase(), metadata == null ? this.getMetadata(method) : metadata));
        }
        for (Method targetMethod : MethodUtils.getMethodsFromSuperClassAndInterface((Method)method)) {
            for (SubCommand subCommand : subCommands = (SubCommand[])targetMethod.getAnnotationsByType(SubCommand.class)) {
                variants.add(new VirtualCommandVariant(info == null ? CommandInfo.createFromAnnotations(annotations) : info, subCommand.value(), subCommand.ignoreCase(), metadata == null ? this.getMetadata(method) : metadata));
            }
        }
    }
}

