/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.requirements;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Map;
import net.apartium.cocoabeans.commands.GenericNode;
import net.apartium.cocoabeans.commands.requirements.CommandRequirementType;
import net.apartium.cocoabeans.commands.requirements.Requirement;
import net.apartium.cocoabeans.commands.requirements.RequirementSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface RequirementFactory {
    @ApiStatus.AvailableSince(value="0.0.37")
    public static RequirementSet createRequirementSet(GenericNode node, Annotation[] annotations, Map<Class<? extends RequirementFactory>, RequirementFactory> requirementFactories, Map<Class<? extends Annotation>, RequirementFactory> externalRequirementFactories) {
        if (annotations == null) {
            return new RequirementSet();
        }
        HashSet<Requirement> result = new HashSet<Requirement>();
        for (Annotation annotation : annotations) {
            Requirement requirement = RequirementFactory.getRequirement(node, annotation, requirementFactories, externalRequirementFactories);
            if (requirement == null) continue;
            result.add(requirement);
        }
        return new RequirementSet(result);
    }

    @ApiStatus.Internal
    private static Requirement getRequirement(GenericNode node, Annotation annotation, Map<Class<? extends RequirementFactory>, RequirementFactory> requirementFactories, Map<Class<? extends Annotation>, RequirementFactory> externalRequirementFactories) {
        RequirementFactory requirementFactory = externalRequirementFactories.get(annotation.annotationType());
        if (requirementFactory != null) {
            return requirementFactory.getRequirement(node, annotation);
        }
        Class<? extends RequirementFactory> requirementFactoryClass = RequirementFactory.getRequirementFactoryClass(annotation);
        if (requirementFactoryClass == null) {
            return null;
        }
        requirementFactory = requirementFactories.computeIfAbsent(requirementFactoryClass, clazz -> RequirementFactory.createFromAnnotation(annotation));
        if (requirementFactory == null) {
            return null;
        }
        return requirementFactory.getRequirement(node, annotation);
    }

    @ApiStatus.AvailableSince(value="0.0.37")
    public static Class<? extends RequirementFactory> getRequirementFactoryClass(Annotation annotation) {
        if (annotation == null) {
            return null;
        }
        CommandRequirementType commandRequirementType = annotation.annotationType().getAnnotation(CommandRequirementType.class);
        return commandRequirementType == null ? null : commandRequirementType.value();
    }

    @ApiStatus.AvailableSince(value="0.0.37")
    public static RequirementFactory createFromAnnotation(Annotation annotation) {
        if (annotation == null) {
            return null;
        }
        Class<? extends RequirementFactory> requirementFactoryClass = RequirementFactory.getRequirementFactoryClass(annotation);
        if (requirementFactoryClass == null) {
            return null;
        }
        try {
            return requirementFactoryClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to instantiate requirement factory: " + String.valueOf(requirementFactoryClass), e);
        }
    }

    @Nullable
    public Requirement getRequirement(GenericNode var1, Object var2);
}

